/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.compiler.compiler;

import com.github.benmanes.caffeine.cache.LoadingCache;
import lombok.Generated;
import org.apache.shardingsphere.sqlfederation.compiler.SQLFederationExecutionPlan;
import org.apache.shardingsphere.sqlfederation.compiler.planner.cache.ExecutionPlanCacheBuilder;
import org.apache.shardingsphere.sqlfederation.compiler.planner.cache.ExecutionPlanCacheKey;
import org.apache.shardingsphere.sqlfederation.config.SQLFederationCacheOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SQLStatementCompilerEngine {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SQLStatementCompilerEngine.class);
    private final LoadingCache<ExecutionPlanCacheKey, SQLFederationExecutionPlan> executionPlanCache;
    private final SQLFederationCacheOption cacheOption;

    public SQLStatementCompilerEngine(SQLFederationCacheOption cacheOption) {
        this.executionPlanCache = ExecutionPlanCacheBuilder.build(cacheOption);
        this.cacheOption = cacheOption;
    }

    public SQLFederationExecutionPlan compile(ExecutionPlanCacheKey cacheKey, boolean useCache) {
        if (log.isDebugEnabled()) {
            String cacheExists = null == this.executionPlanCache.get((Object)cacheKey) ? "not exists" : "exists";
            log.debug("Execution plan cache {} for SQL: {}, useCache: {}.", new Object[]{cacheExists, cacheKey.getSql(), useCache});
        }
        return useCache ? (SQLFederationExecutionPlan)this.executionPlanCache.get((Object)cacheKey) : cacheKey.getSqlStatementCompiler().compile(cacheKey.getSqlStatement(), cacheKey.getSqlStatement().getDatabaseType().getType());
    }

    public void updateCacheOption(SQLFederationCacheOption cacheOption) {
        this.executionPlanCache.policy().eviction().ifPresent(optional -> optional.setMaximum(cacheOption.getMaximumSize()));
    }

    @Generated
    public SQLFederationCacheOption getCacheOption() {
        return this.cacheOption;
    }
}

