/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.compiler.compiler;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.shardingsphere.sqlfederation.compiler.compiler.SQLStatementCompilerEngine;
import org.apache.shardingsphere.sqlfederation.config.SQLFederationCacheOption;

public final class SQLStatementCompilerEngineFactory {
    private static final Map<String, SQLStatementCompilerEngine> COMPILER_ENGINES = new ConcurrentHashMap<String, SQLStatementCompilerEngine>(1, 1.0f);

    public static SQLStatementCompilerEngine getSQLStatementCompilerEngine(String databaseName, String schemaName, SQLFederationCacheOption cacheOption) {
        String cacheKey = databaseName + "." + schemaName;
        SQLStatementCompilerEngine result = COMPILER_ENGINES.get(cacheKey);
        if (null == result) {
            result = COMPILER_ENGINES.computeIfAbsent(cacheKey, unused -> new SQLStatementCompilerEngine(cacheOption));
        } else if (SQLStatementCompilerEngineFactory.isOnlyModifyMaximumSizeConfig(cacheOption, result)) {
            result.updateCacheOption(cacheOption);
        } else if (!cacheOption.equals((Object)result.getCacheOption())) {
            result = new SQLStatementCompilerEngine(cacheOption);
            COMPILER_ENGINES.put(cacheKey, result);
        }
        return result;
    }

    private static boolean isOnlyModifyMaximumSizeConfig(SQLFederationCacheOption cacheOption, SQLStatementCompilerEngine compilerEngine) {
        return cacheOption.getInitialCapacity() == compilerEngine.getCacheOption().getInitialCapacity() && cacheOption.getMaximumSize() != compilerEngine.getCacheOption().getMaximumSize();
    }

    @Generated
    private SQLStatementCompilerEngineFactory() {
    }
}

