/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.opengauss.packet.command.bind;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.binary.BinaryColumnType;
import org.apache.shardingsphere.database.protocol.opengauss.packet.command.OpenGaussCommandPacket;
import org.apache.shardingsphere.database.protocol.opengauss.packet.command.OpenGaussCommandPacketType;
import org.apache.shardingsphere.database.protocol.opengauss.packet.identifier.OpenGaussIdentifierTag;
import org.apache.shardingsphere.database.protocol.postgresql.constant.PostgreSQLValueFormat;
import org.apache.shardingsphere.database.protocol.postgresql.packet.command.query.extended.PostgreSQLColumnType;
import org.apache.shardingsphere.database.protocol.postgresql.packet.command.query.extended.bind.protocol.PostgreSQLBinaryProtocolValue;
import org.apache.shardingsphere.database.protocol.postgresql.packet.command.query.extended.bind.protocol.PostgreSQLBinaryProtocolValueFactory;
import org.apache.shardingsphere.database.protocol.postgresql.payload.PostgreSQLPacketPayload;

public final class OpenGaussComBatchBindPacket
extends OpenGaussCommandPacket {
    private final PostgreSQLPacketPayload payload;
    private final int batchNum;
    private final String statementId;
    private final List<Integer> parameterFormats;
    private final List<PostgreSQLValueFormat> resultFormats;
    private final int eachGroupParametersCount;

    public OpenGaussComBatchBindPacket(PostgreSQLPacketPayload payload) {
        this.payload = payload;
        payload.readInt4();
        this.batchNum = payload.readInt4();
        payload.readStringNul();
        this.statementId = payload.readStringNul();
        int parameterFormatCount = payload.readInt2();
        this.parameterFormats = new ArrayList<Integer>(parameterFormatCount);
        for (int i = 0; i < parameterFormatCount; ++i) {
            this.parameterFormats.add(payload.readInt2());
        }
        int resultFormatsLength = payload.readInt2();
        this.resultFormats = new ArrayList<PostgreSQLValueFormat>(resultFormatsLength);
        for (int i = 0; i < resultFormatsLength; ++i) {
            this.resultFormats.add(PostgreSQLValueFormat.valueOf((int)payload.readInt2()));
        }
        this.eachGroupParametersCount = payload.readInt2();
    }

    public List<List<Object>> readParameterSets(List<PostgreSQLColumnType> parameterTypes) {
        ArrayList<List<Object>> result = new ArrayList<List<Object>>(this.batchNum);
        for (int i = 0; i < this.batchNum; ++i) {
            result.add(this.readOneGroupOfParameters(parameterTypes));
        }
        this.payload.skipReserved(this.payload.getByteBuf().readableBytes());
        return result;
    }

    private List<Object> readOneGroupOfParameters(List<PostgreSQLColumnType> parameterTypes) {
        ArrayList<Object> result = new ArrayList<Object>(this.eachGroupParametersCount);
        for (int paramIndex = 0; paramIndex < this.eachGroupParametersCount; ++paramIndex) {
            int paramValueLength = this.payload.readInt4();
            if (-1 == paramValueLength) {
                result.add(null);
                continue;
            }
            Object parameterValue = this.isTextParameterValue(paramIndex) ? this.getTextParameters(paramValueLength, parameterTypes.get(paramIndex)) : this.getBinaryParameters(paramValueLength, parameterTypes.get(paramIndex));
            result.add(parameterValue);
        }
        return result;
    }

    private boolean isTextParameterValue(int paramIndex) {
        return this.parameterFormats.isEmpty() || 0 == this.parameterFormats.get(paramIndex % this.parameterFormats.size());
    }

    private Object getTextParameters(int paramValueLength, PostgreSQLColumnType paramType) {
        String value = this.payload.getByteBuf().readCharSequence(paramValueLength, this.payload.getCharset()).toString();
        return paramType.getTextValueParser().parse(value);
    }

    private Object getBinaryParameters(int paramValueLength, PostgreSQLColumnType columnType) {
        PostgreSQLBinaryProtocolValue binaryProtocolValue = PostgreSQLBinaryProtocolValueFactory.getBinaryProtocolValue((BinaryColumnType)columnType);
        return binaryProtocolValue.read(this.payload, paramValueLength);
    }

    protected void write(PostgreSQLPacketPayload payload) {
    }

    public OpenGaussIdentifierTag getIdentifier() {
        return OpenGaussCommandPacketType.BATCH_BIND_COMMAND;
    }

    @Generated
    public PostgreSQLPacketPayload getPayload() {
        return this.payload;
    }

    @Generated
    public int getBatchNum() {
        return this.batchNum;
    }

    @Generated
    public String getStatementId() {
        return this.statementId;
    }

    @Generated
    public List<Integer> getParameterFormats() {
        return this.parameterFormats;
    }

    @Generated
    public List<PostgreSQLValueFormat> getResultFormats() {
        return this.resultFormats;
    }

    @Generated
    public int getEachGroupParametersCount() {
        return this.eachGroupParametersCount;
    }
}

