/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.admin.executor;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.authority.checker.AuthorityChecker;
import org.apache.shardingsphere.authority.rule.AuthorityRule;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.metadata.RawQueryResultColumnMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.metadata.RawQueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.type.RawMemoryQueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.type.memory.row.MemoryQueryResultDataRow;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.transparent.TransparentMergedResult;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.resource.ResourceMetaData;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminQueryExecutor;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;

public class DatabaseMetaDataExecutor
implements DatabaseAdminQueryExecutor {
    private QueryResultMetaData queryResultMetaData;
    private MergedResult mergedResult;
    private final String sql;
    private final List<Object> parameters;
    private final List<Map<String, Object>> rows = new LinkedList<Map<String, Object>>();
    private final Collection<String> labels = new LinkedList<String>();

    @Override
    public final void execute(ConnectionSession connectionSession, ShardingSphereMetaData metaData) throws SQLException {
        Collection<ShardingSphereDatabase> databases = this.getDatabases(connectionSession, metaData);
        for (ShardingSphereDatabase each : databases) {
            this.loadMetaData(each);
        }
        this.postProcess();
        this.queryResultMetaData = this.createQueryResultMetaData();
        this.mergedResult = this.createMergedResult();
    }

    protected Collection<ShardingSphereDatabase> getDatabases(ConnectionSession connectionSession, ShardingSphereMetaData metaData) {
        AuthorityChecker authorityChecker = new AuthorityChecker((AuthorityRule)metaData.getGlobalRuleMetaData().getSingleRule(AuthorityRule.class), connectionSession.getConnectionContext().getGrantee());
        String databaseName = connectionSession.getCurrentDatabaseName();
        ShardingSphereDatabase database = metaData.getDatabase(databaseName);
        if (null != database && authorityChecker.isAuthorized(database.getName()) && database.containsDataSource()) {
            return Collections.singleton(database);
        }
        Collection databases = metaData.getAllDatabases().stream().filter(each -> authorityChecker.isAuthorized(each.getName())).filter(ShardingSphereDatabase::containsDataSource).collect(Collectors.toList());
        return databases.isEmpty() ? Collections.emptyList() : Collections.singleton((ShardingSphereDatabase)databases.iterator().next());
    }

    private void loadMetaData(ShardingSphereDatabase database) throws SQLException {
        ResourceMetaData resourceMetaData = database.getResourceMetaData();
        Optional storageUnit = resourceMetaData.getStorageUnits().values().stream().findFirst();
        if (!storageUnit.isPresent()) {
            return;
        }
        try (Connection connection = ((StorageUnit)storageUnit.get()).getDataSource().getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(this.sql);){
            for (int i = 0; i < this.parameters.size(); ++i) {
                preparedStatement.setObject(i + 1, this.parameters.get(i));
            }
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                this.handleResultSet(database, resultSet);
            }
        }
    }

    private void handleResultSet(ShardingSphereDatabase database, ResultSet resultSet) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        while (resultSet.next()) {
            int columnCount = resultSetMetaData.getColumnCount();
            LinkedHashMap<String, Object> rowMap = new LinkedHashMap<String, Object>(columnCount, 1.0f);
            LinkedHashMap<String, String> aliasMap = new LinkedHashMap<String, String>(columnCount, 1.0f);
            for (int i = 1; i < columnCount + 1; ++i) {
                aliasMap.put(resultSetMetaData.getColumnName(i), resultSetMetaData.getColumnLabel(i));
                rowMap.put(resultSetMetaData.getColumnLabel(i), resultSet.getString(i));
            }
            this.preProcess(database, rowMap, aliasMap);
            if (rowMap.isEmpty()) continue;
            this.rows.add(rowMap);
        }
        if (this.rows.isEmpty()) {
            for (int i = 1; i < resultSetMetaData.getColumnCount() + 1; ++i) {
                this.labels.add(resultSetMetaData.getColumnLabel(i));
            }
        }
    }

    protected void preProcess(ShardingSphereDatabase database, Map<String, Object> rows, Map<String, String> alias) throws SQLException {
    }

    protected void postProcess() {
    }

    private RawQueryResultMetaData createQueryResultMetaData() {
        if (this.rows.isEmpty() && !this.labels.isEmpty()) {
            List columns = this.labels.stream().map(each -> new RawQueryResultColumnMetaData("", each, each, 12, "VARCHAR", 20, 0)).collect(Collectors.toList());
            return new RawQueryResultMetaData(columns);
        }
        List columns = this.rows.stream().flatMap(each -> each.keySet().stream()).collect(Collectors.toCollection(LinkedHashSet::new)).stream().map(each -> new RawQueryResultColumnMetaData("", each, each, 12, "VARCHAR", 20, 0)).collect(Collectors.toList());
        return new RawQueryResultMetaData(columns);
    }

    private MergedResult createMergedResult() {
        List resultDataRows = this.rows.stream().map(each -> new MemoryQueryResultDataRow(new LinkedList(each.values()))).collect(Collectors.toList());
        return new TransparentMergedResult((QueryResult)new RawMemoryQueryResult(this.queryResultMetaData, resultDataRows));
    }

    @Generated
    public DatabaseMetaDataExecutor(String sql, List<Object> parameters) {
        this.sql = sql;
        this.parameters = parameters;
    }

    @Override
    @Generated
    public QueryResultMetaData getQueryResultMetaData() {
        return this.queryResultMetaData;
    }

    @Override
    @Generated
    public MergedResult getMergedResult() {
        return this.mergedResult;
    }

    @Generated
    public String getSql() {
        return this.sql;
    }

    @Generated
    public List<Object> getParameters() {
        return this.parameters;
    }

    @Generated
    public List<Map<String, Object>> getRows() {
        return this.rows;
    }

    @Generated
    public Collection<String> getLabels() {
        return this.labels;
    }
}

