/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.admin.executor.variable.charset;

import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.database.protocol.constant.CommonConstants;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.variable.charset.CharsetVariableProvider;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;

public final class CharsetSetExecutor {
    private final DatabaseType databaseType;
    private final ConnectionSession connectionSession;

    public void set(String variableName, String toBeAssignedValue) {
        Optional charsetVariableProvider = DatabaseTypedSPILoader.findService(CharsetVariableProvider.class, (DatabaseType)this.databaseType);
        if (charsetVariableProvider.isPresent() && ((CharsetVariableProvider)charsetVariableProvider.get()).getCharsetVariables().stream().anyMatch(each -> each.equalsIgnoreCase(variableName))) {
            this.connectionSession.getAttributeMap().attr(CommonConstants.CHARSET_ATTRIBUTE_KEY).set((Object)((CharsetVariableProvider)charsetVariableProvider.get()).parseCharset(toBeAssignedValue));
        }
    }

    @Generated
    public CharsetSetExecutor(DatabaseType databaseType, ConnectionSession connectionSession) {
        this.databaseType = databaseType;
        this.connectionSession = connectionSession;
    }
}

