/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.database.type;

import com.google.common.base.Strings;
import lombok.Generated;
import org.apache.shardingsphere.authority.checker.AuthorityChecker;
import org.apache.shardingsphere.authority.rule.AuthorityRule;
import org.apache.shardingsphere.database.connector.core.metadata.database.metadata.DialectDatabaseMetaData;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.database.exception.core.exception.syntax.database.DatabaseDropNotExistsException;
import org.apache.shardingsphere.database.exception.core.exception.syntax.database.UnknownDatabaseException;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.user.Grantee;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.proxy.backend.handler.ProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.UpdateResponseHeader;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.database.DropDatabaseStatement;

public final class DropDatabaseProxyBackendHandler
implements ProxyBackendHandler {
    private final DropDatabaseStatement sqlStatement;
    private final ContextManager contextManager;
    private final ConnectionSession connectionSession;

    @Override
    public ResponseHeader execute() {
        ShardingSphereMetaData metaData = this.contextManager.getMetaDataContexts().getMetaData();
        this.check(this.sqlStatement, metaData, this.connectionSession.getConnectionContext().getGrantee());
        if (this.isDropCurrentDatabase(this.sqlStatement.getDatabaseName())) {
            this.checkSupportedDropCurrentDatabase(this.connectionSession);
            this.connectionSession.setCurrentDatabaseName(null);
        }
        if (metaData.containsDatabase(this.sqlStatement.getDatabaseName())) {
            ShardingSphereDatabase database = metaData.getDatabase(this.sqlStatement.getDatabaseName());
            this.contextManager.getPersistServiceFacade().getModeFacade().getMetaDataManagerService().dropDatabase(database);
        }
        return new UpdateResponseHeader((SQLStatement)this.sqlStatement);
    }

    private void check(DropDatabaseStatement sqlStatement, ShardingSphereMetaData metaData, Grantee grantee) {
        String databaseName = sqlStatement.getDatabaseName().toLowerCase();
        AuthorityRule authorityRule = (AuthorityRule)metaData.getGlobalRuleMetaData().getSingleRule(AuthorityRule.class);
        AuthorityChecker authorityChecker = new AuthorityChecker(authorityRule, grantee);
        ShardingSpherePreconditions.checkState((boolean)authorityChecker.isAuthorized(databaseName), () -> new UnknownDatabaseException(databaseName));
        ShardingSpherePreconditions.checkState((sqlStatement.isIfExists() || metaData.containsDatabase(databaseName) ? 1 : 0) != 0, () -> new DatabaseDropNotExistsException(databaseName));
    }

    private boolean isDropCurrentDatabase(String databaseName) {
        return !Strings.isNullOrEmpty((String)this.connectionSession.getUsedDatabaseName()) && this.connectionSession.getUsedDatabaseName().equals(databaseName);
    }

    private void checkSupportedDropCurrentDatabase(ConnectionSession connectionSession) {
        DialectDatabaseMetaData dialectDatabaseMetaData = new DatabaseTypeRegistry(connectionSession.getProtocolType()).getDialectDatabaseMetaData();
        ShardingSpherePreconditions.checkState((!dialectDatabaseMetaData.getSchemaOption().getDefaultSchema().isPresent() ? 1 : 0) != 0, () -> new UnsupportedOperationException("cannot drop the currently open database"));
    }

    @Generated
    public DropDatabaseProxyBackendHandler(DropDatabaseStatement sqlStatement, ContextManager contextManager, ConnectionSession connectionSession) {
        this.sqlStatement = sqlStatement;
        this.contextManager = contextManager;
        this.connectionSession = connectionSession;
    }
}

