/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql;

import lombok.Generated;
import org.apache.shardingsphere.distsql.statement.DistSQLStatement;
import org.apache.shardingsphere.distsql.statement.type.ral.RALStatement;
import org.apache.shardingsphere.distsql.statement.type.ral.queryable.QueryableRALStatement;
import org.apache.shardingsphere.distsql.statement.type.rdl.RDLStatement;
import org.apache.shardingsphere.distsql.statement.type.rql.RQLStatement;
import org.apache.shardingsphere.distsql.statement.type.rul.RULStatement;
import org.apache.shardingsphere.infra.exception.generic.UnsupportedSQLOperationException;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.handler.ProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.handler.distsql.DistSQLQueryProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.handler.distsql.DistSQLUpdateProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;

public final class DistSQLProxyBackendHandlerFactory {
    public static ProxyBackendHandler newInstance(DistSQLStatement sqlStatement, QueryContext queryContext, ConnectionSession connectionSession) {
        ContextManager contextManager = ProxyContext.getInstance().getContextManager();
        if (sqlStatement instanceof RQLStatement || sqlStatement instanceof RULStatement) {
            return new DistSQLQueryProxyBackendHandler(sqlStatement, queryContext, connectionSession, contextManager);
        }
        if (sqlStatement instanceof RDLStatement) {
            return new DistSQLUpdateProxyBackendHandler(sqlStatement, queryContext, connectionSession, contextManager);
        }
        if (sqlStatement instanceof RALStatement) {
            return sqlStatement instanceof QueryableRALStatement ? new DistSQLQueryProxyBackendHandler(sqlStatement, queryContext, connectionSession, contextManager) : new DistSQLUpdateProxyBackendHandler(sqlStatement, queryContext, connectionSession, contextManager);
        }
        throw new UnsupportedSQLOperationException(sqlStatement.getClass().getName());
    }

    @Generated
    private DistSQLProxyBackendHandlerFactory() {
    }
}

