/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.ral.updatable.variable;

import com.google.common.base.Strings;
import java.util.Map;
import java.util.Properties;
import org.apache.shardingsphere.distsql.handler.engine.update.DistSQLUpdateExecutor;
import org.apache.shardingsphere.distsql.statement.type.ral.updatable.SetDistVariableStatement;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.config.props.temporary.TemporaryConfigurationPropertyKey;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.kernel.syntax.InvalidVariableValueException;
import org.apache.shardingsphere.infra.exception.kernel.syntax.UnsupportedVariableException;
import org.apache.shardingsphere.infra.props.TypedPropertyKey;
import org.apache.shardingsphere.infra.props.TypedPropertyValue;
import org.apache.shardingsphere.infra.props.exception.TypedPropertyValueException;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPI;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.quartz.CronExpression;

public final class SetDistVariableExecutor
implements DistSQLUpdateExecutor<SetDistVariableStatement> {
    public void executeUpdate(SetDistVariableStatement sqlStatement, ContextManager contextManager) {
        ShardingSpherePreconditions.checkState((boolean)(this.getEnumType(sqlStatement.getName()) instanceof TypedPropertyKey), () -> new UnsupportedVariableException(sqlStatement.getName()));
        this.handleConfigurationProperty(contextManager, (TypedPropertyKey)this.getEnumType(sqlStatement.getName()), sqlStatement.getValue());
    }

    private Enum<?> getEnumType(String name) {
        try {
            return ConfigurationPropertyKey.valueOf((String)name.toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            try {
                return TemporaryConfigurationPropertyKey.valueOf((String)name.toUpperCase());
            }
            catch (IllegalArgumentException exception) {
                throw new UnsupportedVariableException(name);
            }
        }
    }

    private void handleConfigurationProperty(ContextManager contextManager, TypedPropertyKey propertyKey, String value) {
        MetaDataContexts metaDataContexts = contextManager.getMetaDataContexts();
        Properties props = new Properties();
        props.putAll((Map<?, ?>)metaDataContexts.getMetaData().getProps().getProps());
        props.putAll((Map<?, ?>)metaDataContexts.getMetaData().getTemporaryProps().getProps());
        props.put(propertyKey.getKey(), this.getValue(propertyKey, value));
        contextManager.getPersistServiceFacade().getModeFacade().getMetaDataManagerService().alterProperties(props);
    }

    private Object getValue(TypedPropertyKey propertyKey, String value) {
        try {
            Object propertyValue = new TypedPropertyValue(propertyKey, value).getValue();
            this.checkProxyMetaDataCollectorCron(propertyKey, value);
            if (Enum.class.isAssignableFrom(propertyKey.getType())) {
                return propertyValue.toString();
            }
            return TypedSPI.class.isAssignableFrom(propertyKey.getType()) ? ((TypedSPI)propertyValue).getType().toString() : propertyValue;
        }
        catch (TypedPropertyValueException ignored) {
            throw new InvalidVariableValueException(value);
        }
    }

    private void checkProxyMetaDataCollectorCron(TypedPropertyKey propertyKey, String value) {
        if (TemporaryConfigurationPropertyKey.PROXY_META_DATA_COLLECTOR_CRON == propertyKey) {
            ShardingSpherePreconditions.checkState((!Strings.isNullOrEmpty((String)value) && CronExpression.isValidExpression((String)value) ? 1 : 0) != 0, () -> new InvalidVariableValueException(value));
        }
    }

    public Class<SetDistVariableStatement> getType() {
        return SetDistVariableStatement.class;
    }
}

