/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.api.type;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.PipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.spi.JdbcQueryPropertiesExtension;
import org.apache.shardingsphere.database.connector.core.jdbcurl.appender.JdbcUrlAppender;
import org.apache.shardingsphere.database.connector.core.jdbcurl.parser.StandardJdbcUrlParser;
import org.apache.shardingsphere.database.connector.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeFactory;
import org.apache.shardingsphere.infra.datasource.pool.props.domain.DataSourcePoolProperties;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.yaml.config.swapper.resource.YamlDataSourceConfigurationSwapper;

public final class StandardPipelineDataSourceConfiguration
implements PipelineDataSourceConfiguration {
    public static final String TYPE = "JDBC";
    private static final String DATA_SOURCE_CLASS_NAME = "dataSourceClassName";
    private final String parameter;
    private final DatabaseType databaseType;
    private final String url;
    private final String username;
    private final String password;
    private final DataSourcePoolProperties dataSourcePoolProps;

    public StandardPipelineDataSourceConfiguration(String poolYamlContent) {
        this((Map)YamlEngine.unmarshal((String)poolYamlContent, Map.class));
    }

    public StandardPipelineDataSourceConfiguration(Map<String, Object> poolProps) {
        this.parameter = YamlEngine.marshal(poolProps);
        HashMap<String, Object> newPoolProps = new HashMap<String, Object>(poolProps);
        for (String each : Arrays.asList("minPoolSize", "minimumIdle")) {
            newPoolProps.put(each, "1");
        }
        if (newPoolProps.containsKey("jdbcUrl")) {
            newPoolProps.put("url", newPoolProps.get("jdbcUrl"));
            newPoolProps.remove("jdbcUrl");
        }
        this.databaseType = DatabaseTypeFactory.get((String)String.valueOf(newPoolProps.get("url")));
        newPoolProps.remove(DATA_SOURCE_CLASS_NAME);
        newPoolProps.put(DATA_SOURCE_CLASS_NAME, "com.zaxxer.hikari.HikariDataSource");
        this.appendJdbcQueryProperties(newPoolProps);
        this.url = String.valueOf(newPoolProps.get("url"));
        this.username = String.valueOf(newPoolProps.get("username"));
        this.password = String.valueOf(newPoolProps.get("password"));
        this.dataSourcePoolProps = new YamlDataSourceConfigurationSwapper().swapToDataSourcePoolProperties(newPoolProps);
    }

    private void appendJdbcQueryProperties(Map<String, Object> poolProps) {
        Optional extension = DatabaseTypedSPILoader.findService(JdbcQueryPropertiesExtension.class, (DatabaseType)this.databaseType);
        if (!extension.isPresent()) {
            return;
        }
        String jdbcUrl = String.valueOf(poolProps.get("url"));
        Properties queryProps = new StandardJdbcUrlParser().parseQueryProperties(jdbcUrl.contains("?") ? jdbcUrl.substring(jdbcUrl.indexOf("?") + 1) : "");
        ((JdbcQueryPropertiesExtension)extension.get()).extendQueryProperties(queryProps);
        String url = new JdbcUrlAppender().appendQueryProperties(jdbcUrl, queryProps);
        poolProps.put("url", url);
    }

    @Override
    public Object getDataSourceConfiguration() {
        return this.dataSourcePoolProps;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StandardPipelineDataSourceConfiguration)) {
            return false;
        }
        StandardPipelineDataSourceConfiguration other = (StandardPipelineDataSourceConfiguration)o;
        String this$parameter = this.getParameter();
        String other$parameter = other.getParameter();
        return !(this$parameter == null ? other$parameter != null : !this$parameter.equals(other$parameter));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $parameter = this.getParameter();
        result = result * 59 + ($parameter == null ? 43 : $parameter.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getParameter() {
        return this.parameter;
    }

    @Override
    @Generated
    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }
}

