/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rewrite.parameter.impl;

import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.segment.select.pagination.PaginationContext;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.type.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.ParameterBuilder;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.impl.GroupedParameterBuilder;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.impl.StandardParameterBuilder;
import org.apache.shardingsphere.infra.rewrite.parameter.rewriter.ParameterRewriter;
import org.apache.shardingsphere.infra.route.context.RouteContext;

public final class ShardingPaginationParameterRewriter
implements ParameterRewriter {
    private final RouteContext routeContext;

    public boolean isNeedRewrite(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof SelectStatementContext && ((SelectStatementContext)sqlStatementContext).getPaginationContext().isHasPagination() && !this.routeContext.isSingleRouting();
    }

    public void rewrite(ParameterBuilder paramBuilder, SQLStatementContext sqlStatementContext, List<Object> params) {
        PaginationContext pagination = ((SelectStatementContext)sqlStatementContext).getPaginationContext();
        pagination.getOffsetParameterIndex().ifPresent(optional -> this.rewriteOffset(pagination, (int)optional, paramBuilder));
        pagination.getRowCountParameterIndex().ifPresent(optional -> this.rewriteRowCount(pagination, (int)optional, paramBuilder, sqlStatementContext));
    }

    private void rewriteOffset(PaginationContext pagination, int offsetParamIndex, ParameterBuilder paramBuilder) {
        if (paramBuilder instanceof StandardParameterBuilder) {
            ((StandardParameterBuilder)paramBuilder).addReplacedParameters(offsetParamIndex, (Object)pagination.getRevisedOffset());
            return;
        }
        this.rewriteOffset(pagination, offsetParamIndex, (GroupedParameterBuilder)paramBuilder);
    }

    private void rewriteOffset(PaginationContext pagination, int offsetParamIndex, GroupedParameterBuilder paramBuilder) {
        if (paramBuilder.isContainsGroupedParams()) {
            paramBuilder.getAfterGenericParameterBuilder().addReplacedParameters(offsetParamIndex - paramBuilder.getAfterGenericParameterOffset(), (Object)pagination.getRevisedOffset());
        } else {
            paramBuilder.getBeforeGenericParameterBuilder().addReplacedParameters(offsetParamIndex, (Object)pagination.getRevisedOffset());
        }
    }

    private void rewriteRowCount(PaginationContext pagination, int rowCountParamIndex, ParameterBuilder paramBuilder, SQLStatementContext sqlStatementContext) {
        if (paramBuilder instanceof StandardParameterBuilder) {
            ((StandardParameterBuilder)paramBuilder).addReplacedParameters(rowCountParamIndex, (Object)pagination.getRevisedRowCount((SelectStatementContext)sqlStatementContext));
            return;
        }
        ShardingPaginationParameterRewriter.rewriteRowCount(pagination, rowCountParamIndex, (GroupedParameterBuilder)paramBuilder, (SelectStatementContext)sqlStatementContext);
    }

    private static void rewriteRowCount(PaginationContext pagination, int rowCountParamIndex, GroupedParameterBuilder paramBuilder, SelectStatementContext sqlStatementContext) {
        if (paramBuilder.isContainsGroupedParams()) {
            paramBuilder.getAfterGenericParameterBuilder().addReplacedParameters(rowCountParamIndex - paramBuilder.getAfterGenericParameterOffset(), (Object)pagination.getRevisedRowCount(sqlStatementContext));
        } else {
            paramBuilder.getBeforeGenericParameterBuilder().addReplacedParameters(rowCountParamIndex, (Object)pagination.getRevisedRowCount(sqlStatementContext));
        }
    }

    @Generated
    public ShardingPaginationParameterRewriter(RouteContext routeContext) {
        this.routeContext = routeContext;
    }
}

