/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.firebird.handler.admin.executor.variable.charset;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.shardingsphere.database.connector.core.metadata.database.enums.QuoteCharacter;

public enum FirebirdCharacterSets {
    ASCII(() -> StandardCharsets.US_ASCII, new String[0]),
    BIG_5(() -> Charset.forName("BIG5"), new String[0]),
    DOS437(() -> Charset.forName("IBM437"), new String[0]),
    DOS737(() -> Charset.forName("IBM737"), new String[0]),
    DOS775(() -> Charset.forName("IBM775"), new String[0]),
    DOS850(() -> Charset.forName("IBM850"), new String[0]),
    DOS852(() -> Charset.forName("IBM852"), new String[0]),
    DOS857(() -> Charset.forName("IBM857"), new String[0]),
    DOS858(() -> Charset.forName("IBM858"), new String[0]),
    DOS860(() -> Charset.forName("IBM860"), new String[0]),
    DOS861(() -> Charset.forName("IBM861"), new String[0]),
    DOS862(() -> Charset.forName("IBM862"), new String[0]),
    DOS863(() -> Charset.forName("IBM863"), new String[0]),
    DOS864(() -> Charset.forName("IBM864"), new String[0]),
    DOS865(() -> Charset.forName("IBM865"), new String[0]),
    DOS866(() -> Charset.forName("IBM866"), new String[0]),
    DOS869(() -> Charset.forName("IBM869"), new String[0]),
    EUCJ_0208(() -> Charset.forName("EUC-JP"), new String[0]),
    GB_2312(() -> Charset.forName("GB2312"), new String[0]),
    ISO8859_1(() -> StandardCharsets.ISO_8859_1, new String[0]),
    ISO8859_2(() -> Charset.forName("ISO8859_2"), new String[0]),
    ISO8859_3(() -> Charset.forName("ISO8859_3"), new String[0]),
    ISO8859_4(() -> Charset.forName("ISO8859_4"), new String[0]),
    ISO8859_5(() -> Charset.forName("ISO8859_5"), new String[0]),
    ISO8859_6(() -> Charset.forName("ISO8859_6"), new String[0]),
    ISO8859_7(() -> Charset.forName("ISO8859_7"), new String[0]),
    ISO8859_8(() -> Charset.forName("ISO8859_8"), new String[0]),
    ISO8859_9(() -> Charset.forName("ISO8859_9"), new String[0]),
    ISO8859_13(() -> Charset.forName("ISO8859_13"), new String[0]),
    KOI8R(() -> Charset.forName("KOI8-R"), new String[0]),
    KOI8U(() -> Charset.forName("KOI8-U"), new String[0]),
    KSC_5601(() -> Charset.forName("EUC-KR"), new String[0]),
    NONE(Charset::defaultCharset, new String[0]),
    OCTETS(Charset::defaultCharset, "BINARY"),
    SJIS_0208(() -> Charset.forName("ISO-2022-JP"), new String[0]),
    UNICODE_FSS(() -> StandardCharsets.UTF_8, new String[0]),
    UTF8(() -> StandardCharsets.UTF_8, new String[0]),
    WIN1250(() -> Charset.forName("windows-1250"), new String[0]),
    WIN1251(() -> Charset.forName("windows-1251"), new String[0]),
    WIN1252(() -> Charset.forName("windows-1252"), new String[0]),
    WIN1253(() -> Charset.forName("windows-1253"), new String[0]),
    WIN1254(() -> Charset.forName("windows-1254"), new String[0]),
    WIN1255(() -> Charset.forName("windows-1255"), new String[0]),
    WIN1256(() -> Charset.forName("windows-1256"), new String[0]),
    WIN1257(() -> Charset.forName("windows-1257"), new String[0]),
    WIN1258(() -> Charset.forName("windows-1258"), new String[0]);

    private static final Map<String, FirebirdCharacterSets> CHARACTER_SETS_MAP;
    private final Charset charset;
    private final String[] aliases;

    private FirebirdCharacterSets(Supplier<Charset> charsetSupplier, String ... aliases) {
        Charset result = null;
        try {
            result = charsetSupplier.get();
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            // empty catch block
        }
        this.charset = result;
        this.aliases = aliases;
    }

    public static Charset findCharacterSet(String charsetName) {
        String formattedCharsetName = FirebirdCharacterSets.formatValue(charsetName);
        FirebirdCharacterSets result = CHARACTER_SETS_MAP.get(formattedCharsetName.toUpperCase());
        return null == result || null == result.charset ? Charset.forName(formattedCharsetName) : result.charset;
    }

    private static String formatValue(String value) {
        return QuoteCharacter.SINGLE_QUOTE.isWrapped(value) || QuoteCharacter.QUOTE.isWrapped(value) ? value.substring(1, value.length() - 1) : value.trim();
    }

    static {
        HashMap<String, FirebirdCharacterSets> map = new HashMap<String, FirebirdCharacterSets>(64, 1.0f);
        for (FirebirdCharacterSets each : FirebirdCharacterSets.values()) {
            map.put(each.name(), each);
            for (String eachAlias : each.aliases) {
                map.put(eachAlias.toUpperCase(), each);
            }
        }
        CHARACTER_SETS_MAP = map;
    }
}

