/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.context;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineContextKey;
import org.apache.shardingsphere.infra.instance.metadata.InstanceType;
import org.apache.shardingsphere.mode.manager.ContextManager;

public final class PipelineContextManager {
    private static final Map<PipelineContextKey, ContextManager> CONTEXT_MAP = new ConcurrentHashMap<PipelineContextKey, ContextManager>();

    public static ContextManager getContext(PipelineContextKey key) {
        return CONTEXT_MAP.get(key);
    }

    public static ContextManager getProxyContext() {
        return CONTEXT_MAP.get(new PipelineContextKey(InstanceType.PROXY));
    }

    public static void putContext(PipelineContextKey key, ContextManager context) {
        CONTEXT_MAP.put(key, context);
    }

    public static void removeContext(PipelineContextKey key) {
        CONTEXT_MAP.remove(key);
    }

    @Generated
    private PipelineContextManager() {
    }
}

