/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.DumperCommonContext;
import org.apache.shardingsphere.data.pipeline.core.metadata.model.PipelineColumnMetaData;
import org.apache.shardingsphere.data.pipeline.core.ratelimit.JobRateLimitAlgorithm;
import org.apache.shardingsphere.infra.metadata.identifier.ShardingSphereIdentifier;

public final class InventoryDumperContext {
    private final DumperCommonContext commonContext;
    private String actualTableName;
    private String logicTableName;
    private List<PipelineColumnMetaData> uniqueKeyColumns;
    private List<ShardingSphereIdentifier> targetUniqueKeysNames;
    private List<String> insertColumnNames;
    private int shardingItem;
    private int batchSize = 1000;
    private JobRateLimitAlgorithm rateLimitAlgorithm;

    public InventoryDumperContext(DumperCommonContext commonContext) {
        this.commonContext = new DumperCommonContext(commonContext.getDataSourceName(), commonContext.getDataSourceConfig(), commonContext.getTableNameMapper(), commonContext.getTableAndSchemaNameMapper());
    }

    public void setUniqueKeyColumns(List<PipelineColumnMetaData> uniqueKeyColumns) {
        this.uniqueKeyColumns = uniqueKeyColumns;
        this.targetUniqueKeysNames = this.hasUniqueKey() ? uniqueKeyColumns.stream().map(each -> new ShardingSphereIdentifier(each.getName())).collect(Collectors.toList()) : Collections.emptyList();
    }

    public boolean hasUniqueKey() {
        return null != this.uniqueKeyColumns && !this.uniqueKeyColumns.isEmpty();
    }

    public List<String> getQueryColumnNames() {
        return Optional.ofNullable(this.insertColumnNames).orElse(Collections.singletonList("*"));
    }

    @Generated
    public DumperCommonContext getCommonContext() {
        return this.commonContext;
    }

    @Generated
    public String getActualTableName() {
        return this.actualTableName;
    }

    @Generated
    public String getLogicTableName() {
        return this.logicTableName;
    }

    @Generated
    public List<PipelineColumnMetaData> getUniqueKeyColumns() {
        return this.uniqueKeyColumns;
    }

    @Generated
    public List<ShardingSphereIdentifier> getTargetUniqueKeysNames() {
        return this.targetUniqueKeysNames;
    }

    @Generated
    public List<String> getInsertColumnNames() {
        return this.insertColumnNames;
    }

    @Generated
    public int getShardingItem() {
        return this.shardingItem;
    }

    @Generated
    public int getBatchSize() {
        return this.batchSize;
    }

    @Generated
    public JobRateLimitAlgorithm getRateLimitAlgorithm() {
        return this.rateLimitAlgorithm;
    }

    @Generated
    public void setActualTableName(String actualTableName) {
        this.actualTableName = actualTableName;
    }

    @Generated
    public void setLogicTableName(String logicTableName) {
        this.logicTableName = logicTableName;
    }

    @Generated
    public void setTargetUniqueKeysNames(List<ShardingSphereIdentifier> targetUniqueKeysNames) {
        this.targetUniqueKeysNames = targetUniqueKeysNames;
    }

    @Generated
    public void setInsertColumnNames(List<String> insertColumnNames) {
        this.insertColumnNames = insertColumnNames;
    }

    @Generated
    public void setShardingItem(int shardingItem) {
        this.shardingItem = shardingItem;
    }

    @Generated
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    @Generated
    public void setRateLimitAlgorithm(JobRateLimitAlgorithm rateLimitAlgorithm) {
        this.rateLimitAlgorithm = rateLimitAlgorithm;
    }

    @Generated
    public String toString() {
        return "InventoryDumperContext(commonContext=" + this.getCommonContext() + ", actualTableName=" + this.getActualTableName() + ", logicTableName=" + this.getLogicTableName() + ", uniqueKeyColumns=" + this.getUniqueKeyColumns() + ", targetUniqueKeysNames=" + this.getTargetUniqueKeysNames() + ", insertColumnNames=" + this.getInsertColumnNames() + ", shardingItem=" + this.getShardingItem() + ", batchSize=" + this.getBatchSize() + ", rateLimitAlgorithm=" + this.getRateLimitAlgorithm() + ")";
    }
}

