/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.query.calculator;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.DataConsistencyCheckUtils;
import org.apache.shardingsphere.data.pipeline.core.exception.PipelineJobCancelingException;
import org.apache.shardingsphere.data.pipeline.core.exception.data.PipelineTableDataConsistencyCheckLoadingFailedException;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.column.InventoryColumnValueReaderEngine;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.query.PipelineDatabaseResources;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.query.QueryType;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.query.Range;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.query.StreamingRangeType;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.query.calculator.AbstractStreamingTableInventoryCalculator;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.query.calculator.CalculationContext;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.query.calculator.TableInventoryCalculateParameter;
import org.apache.shardingsphere.data.pipeline.core.query.JDBCStreamQueryBuilder;
import org.apache.shardingsphere.data.pipeline.core.sqlbuilder.sql.PipelineInventoryCalculateSQLBuilder;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.external.sql.type.kernel.category.PipelineSQLException;
import org.apache.shardingsphere.infra.util.close.QuietlyCloser;

public abstract class AbstractRecordTableInventoryCalculator<S, C>
extends AbstractStreamingTableInventoryCalculator<S> {
    private static final int DEFAULT_STREAMING_CHUNK_COUNT = 100;
    private final int chunkSize;
    private final int streamingChunkCount;
    private final StreamingRangeType streamingRangeType;

    protected AbstractRecordTableInventoryCalculator(int chunkSize, StreamingRangeType streamingRangeType) {
        this(chunkSize, 100, streamingRangeType);
    }

    @Override
    public Optional<S> calculateChunk(TableInventoryCalculateParameter param) {
        List<C> records = this.calculateChunk0(param);
        if (records.isEmpty()) {
            return Optional.empty();
        }
        Object maxUniqueKeyValue = this.getFirstUniqueKeyValue(records.get(records.size() - 1), param.getFirstUniqueKey().getName());
        if (QueryType.RANGE_QUERY == param.getQueryType()) {
            param.setRange(Range.openClosed(maxUniqueKeyValue, param.getRange().getUpperBound()));
        }
        return Optional.of(this.convertRecordsToResult(records, maxUniqueKeyValue));
    }

    private List<C> calculateChunk0(TableInventoryCalculateParameter param) {
        InventoryColumnValueReaderEngine columnValueReaderEngine = new InventoryColumnValueReaderEngine(param.getDatabaseType());
        try {
            if (QueryType.POINT_QUERY == param.getQueryType()) {
                return this.pointQuery(param, columnValueReaderEngine);
            }
            if (StreamingRangeType.LARGE == this.streamingRangeType) {
                return this.allQuery(param, columnValueReaderEngine);
            }
            if (param.getUniqueKeys().size() <= 1) {
                return this.rangeQueryWithSingleColumUniqueKey(param, columnValueReaderEngine, 1);
            }
            return this.rangeQueryWithMultiColumUniqueKeys(param, columnValueReaderEngine);
        }
        catch (PipelineJobCancelingException | PipelineSQLException ex) {
            throw ex;
        }
        catch (RuntimeException | SQLException ex) {
            throw new PipelineTableDataConsistencyCheckLoadingFailedException(param.getTable(), ex);
        }
    }

    private List<C> pointQuery(TableInventoryCalculateParameter param, InventoryColumnValueReaderEngine columnValueReaderEngine) throws SQLException {
        LinkedList<C> result = new LinkedList<C>();
        CalculationContext<C> calculationContext = this.prepareCalculationContext(param);
        this.prepareDatabaseResources(calculationContext, param);
        ResultSet resultSet = calculationContext.getDatabaseResources().getResultSet();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        while (resultSet.next()) {
            ShardingSpherePreconditions.checkState((!this.isCanceling() ? 1 : 0) != 0, () -> new PipelineJobCancelingException("Calculate chunk canceled, qualified table: %s", param.getTable()));
            C record = this.readRecord(resultSet, resultSetMetaData, columnValueReaderEngine);
            result.add(record);
        }
        return result;
    }

    private List<C> allQuery(TableInventoryCalculateParameter param, InventoryColumnValueReaderEngine columnValueReaderEngine) throws SQLException {
        LinkedList<C> result = new LinkedList<C>();
        CalculationContext<C> calculationContext = this.prepareCalculationContext(param);
        this.prepareDatabaseResources(calculationContext, param);
        ResultSet resultSet = calculationContext.getDatabaseResources().getResultSet();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        while (resultSet.next()) {
            ShardingSpherePreconditions.checkState((!this.isCanceling() ? 1 : 0) != 0, () -> new PipelineJobCancelingException("Calculate chunk canceled, qualified table: %s", param.getTable()));
            result.add(this.readRecord(resultSet, resultSetMetaData, columnValueReaderEngine));
            if (result.size() != this.chunkSize) continue;
        }
        if (result.isEmpty()) {
            QuietlyCloser.close(calculationContext);
        }
        return result;
    }

    private List<C> rangeQueryWithSingleColumUniqueKey(TableInventoryCalculateParameter param, InventoryColumnValueReaderEngine columnValueReaderEngine, int round) throws SQLException {
        LinkedList<C> result = new LinkedList<C>();
        CalculationContext<C> calculationContext = this.prepareCalculationContext(param);
        this.prepareDatabaseResources(calculationContext, param);
        ResultSet resultSet = calculationContext.getDatabaseResources().getResultSet();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        while (resultSet.next()) {
            ShardingSpherePreconditions.checkState((!this.isCanceling() ? 1 : 0) != 0, () -> new PipelineJobCancelingException("Calculate chunk canceled, qualified table: %s", param.getTable()));
            result.add(this.readRecord(resultSet, resultSetMetaData, columnValueReaderEngine));
            if (result.size() != this.chunkSize) continue;
            return result;
        }
        calculationContext.getDatabaseResources().reset();
        if (result.isEmpty() && 1 == round) {
            return this.rangeQueryWithSingleColumUniqueKey(param, columnValueReaderEngine, round + 1);
        }
        return result;
    }

    private List<C> rangeQueryWithMultiColumUniqueKeys(TableInventoryCalculateParameter param, InventoryColumnValueReaderEngine columnValueReaderEngine) throws SQLException {
        CalculationContext<C> calculationContext = this.prepareCalculationContext(param);
        if (calculationContext.getRecordDeque().size() > this.chunkSize) {
            return this.queryFromBuffer(calculationContext.getRecordDeque());
        }
        this.doRangeQueryWithMultiColumUniqueKeys(param, calculationContext, columnValueReaderEngine);
        return this.queryFromBuffer(calculationContext.getRecordDeque());
    }

    private void doRangeQueryWithMultiColumUniqueKeys(TableInventoryCalculateParameter param, CalculationContext<C> calculationContext, InventoryColumnValueReaderEngine columnValueReaderEngine) throws SQLException {
        this.prepareDatabaseResources(calculationContext, param);
        ResultSet resultSet = calculationContext.getDatabaseResources().getResultSet();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        C previousRecord = calculationContext.getRecordDeque().pollLast();
        LinkedList<C> duplicateRecords = new LinkedList<C>();
        if (null != previousRecord) {
            duplicateRecords.add(previousRecord);
        }
        EqualsBuilder equalsBuilder = new EqualsBuilder();
        String firstUniqueKey = param.getFirstUniqueKey().getName();
        while (resultSet.next()) {
            ShardingSpherePreconditions.checkState((!this.isCanceling() ? 1 : 0) != 0, () -> new PipelineJobCancelingException("Calculate chunk canceled, qualified table: %s", param.getTable()));
            C record = this.readRecord(resultSet, resultSetMetaData, columnValueReaderEngine);
            if (null == previousRecord || DataConsistencyCheckUtils.isMatched(equalsBuilder, this.getFirstUniqueKeyValue(previousRecord, firstUniqueKey), this.getFirstUniqueKeyValue(record, firstUniqueKey))) {
                duplicateRecords.add(record);
                previousRecord = record;
                continue;
            }
            previousRecord = record;
            if (!duplicateRecords.isEmpty()) {
                calculationContext.getRecordDeque().addAll(duplicateRecords);
                duplicateRecords.clear();
            }
            if (calculationContext.getRecordDeque().size() >= this.chunkSize) {
                calculationContext.getRecordDeque().add(record);
                return;
            }
            duplicateRecords.add(record);
        }
        calculationContext.getDatabaseResources().reset();
        if (!duplicateRecords.isEmpty()) {
            calculationContext.getRecordDeque().addAll(this.pointRangeQuery(param, duplicateRecords.get(0), columnValueReaderEngine));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<C> pointRangeQuery(TableInventoryCalculateParameter param, C duplicateRecord, InventoryColumnValueReaderEngine columnValueReaderEngine) throws SQLException {
        Object duplicateUniqueKeyValue = this.getFirstUniqueKeyValue(duplicateRecord, param.getFirstUniqueKey().getName());
        TableInventoryCalculateParameter newParam = this.buildPointRangeQueryCalculateParameter(param, duplicateUniqueKeyValue);
        try {
            List<C> list = this.pointQuery(newParam, columnValueReaderEngine);
            return list;
        }
        finally {
            QuietlyCloser.close((AutoCloseable)newParam.getCalculationContext());
        }
    }

    private List<C> queryFromBuffer(Deque<C> recordDeque) {
        C record;
        LinkedList<C> result = new LinkedList<C>();
        while (null != (record = recordDeque.pollFirst())) {
            result.add(record);
            if (result.size() != this.chunkSize) continue;
            break;
        }
        return result;
    }

    private CalculationContext<C> prepareCalculationContext(TableInventoryCalculateParameter param) {
        CalculationContext result = (CalculationContext)param.getCalculationContext();
        if (null != result) {
            return result;
        }
        result = new CalculationContext();
        param.setCalculationContext(result);
        return result;
    }

    private void prepareDatabaseResources(CalculationContext<C> calculationContext, TableInventoryCalculateParameter param) throws SQLException {
        if (calculationContext.getDatabaseResources().isReady()) {
            return;
        }
        PipelineDatabaseResources databaseResources = calculationContext.getDatabaseResources();
        Connection connection = param.getDataSource().getConnection();
        databaseResources.setConnection(connection);
        String sql = this.getQuerySQL(param);
        PreparedStatement preparedStatement = JDBCStreamQueryBuilder.build(param.getDatabaseType(), connection, sql, this.chunkSize);
        this.setCurrentStatement(preparedStatement);
        databaseResources.setPreparedStatement(preparedStatement);
        this.setParameters(preparedStatement, param);
        ResultSet resultSet = preparedStatement.executeQuery();
        databaseResources.setResultSet(resultSet);
        databaseResources.setReady(true);
    }

    private String getQuerySQL(TableInventoryCalculateParameter param) {
        ShardingSpherePreconditions.checkState((null != param.getUniqueKeys() && !param.getUniqueKeys().isEmpty() && null != param.getFirstUniqueKey() ? 1 : 0) != 0, () -> new UnsupportedOperationException("Record inventory calculator does not support table without unique key and primary key now."));
        PipelineInventoryCalculateSQLBuilder pipelineSQLBuilder = new PipelineInventoryCalculateSQLBuilder(param.getDatabaseType());
        Collection<String> columnNames = param.getColumnNames().isEmpty() ? Collections.singleton("*") : param.getColumnNames();
        switch (param.getQueryType()) {
            case RANGE_QUERY: {
                return pipelineSQLBuilder.buildRangeQueryOrderingSQL(param.getTable(), columnNames, param.getUniqueKeysNames(), param.getRange(), StreamingRangeType.SMALL == this.streamingRangeType, param.getShardingColumnsNames());
            }
            case POINT_QUERY: {
                return pipelineSQLBuilder.buildPointQuerySQL(param.getTable(), columnNames, param.getUniqueKeysNames(), param.getShardingColumnsNames());
            }
        }
        throw new UnsupportedOperationException("Query type: " + (Object)((Object)param.getQueryType()));
    }

    private void setParameters(PreparedStatement preparedStatement, TableInventoryCalculateParameter param) throws SQLException {
        QueryType queryType = param.getQueryType();
        if (queryType == QueryType.RANGE_QUERY) {
            Range<?> range = param.getRange();
            ShardingSpherePreconditions.checkNotNull(range, () -> new PipelineTableDataConsistencyCheckLoadingFailedException(param.getTable(), new RuntimeException("Unique keys values range is null.")));
            int parameterIndex = 1;
            if (null != range.getLowerBound()) {
                preparedStatement.setObject(parameterIndex++, range.getLowerBound());
            }
            if (null != range.getUpperBound()) {
                preparedStatement.setObject(parameterIndex++, range.getUpperBound());
            }
            if (StreamingRangeType.SMALL == this.streamingRangeType) {
                preparedStatement.setObject(parameterIndex, this.chunkSize * this.streamingChunkCount);
            }
        } else if (queryType == QueryType.POINT_QUERY) {
            Collection<Object> uniqueKeysValues = param.getUniqueKeysValues();
            ShardingSpherePreconditions.checkNotNull(uniqueKeysValues, () -> new PipelineTableDataConsistencyCheckLoadingFailedException(param.getTable(), new RuntimeException("Unique keys values is null.")));
            int parameterIndex = 1;
            for (Object each : uniqueKeysValues) {
                preparedStatement.setObject(parameterIndex++, each);
            }
            if (!param.getShardingColumnsNames().isEmpty()) {
                List<Object> shardingColumnsValues = param.getShardingColumnsValues();
                ShardingSpherePreconditions.checkNotNull(shardingColumnsValues, () -> new PipelineTableDataConsistencyCheckLoadingFailedException(param.getTable(), new RuntimeException("Sharding columns values is null when names not empty.")));
                for (Object each : shardingColumnsValues) {
                    preparedStatement.setObject(parameterIndex++, each);
                }
            }
        } else {
            throw new UnsupportedOperationException("Query type: " + (Object)((Object)queryType));
        }
    }

    private TableInventoryCalculateParameter buildPointRangeQueryCalculateParameter(TableInventoryCalculateParameter param, Object uniqueKeyValue) {
        TableInventoryCalculateParameter result = new TableInventoryCalculateParameter(param.getDataSource(), param.getTable(), param.getColumnNames(), Collections.singletonList(param.getFirstUniqueKey()), QueryType.POINT_QUERY, param.getQueryCondition());
        result.setUniqueKeysValues(Collections.singletonList(uniqueKeyValue));
        result.setShardingColumnsNames(param.getShardingColumnsNames());
        result.setShardingColumnsValues(param.getShardingColumnsValues());
        return result;
    }

    protected abstract C readRecord(ResultSet var1, ResultSetMetaData var2, InventoryColumnValueReaderEngine var3) throws SQLException;

    protected abstract Object getFirstUniqueKeyValue(C var1, String var2);

    protected abstract S convertRecordsToResult(List<C> var1, Object var2);

    @Generated
    public AbstractRecordTableInventoryCalculator(int chunkSize, int streamingChunkCount, StreamingRangeType streamingRangeType) {
        this.chunkSize = chunkSize;
        this.streamingChunkCount = streamingChunkCount;
        this.streamingRangeType = streamingRangeType;
    }
}

