/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.ingest.record;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.ingest.record.Column;
import org.apache.shardingsphere.data.pipeline.core.ingest.record.DataRecord;

public final class RecordUtils {
    public static List<Column> extractConditionColumns(DataRecord dataRecord, Collection<String> shardingColumns) {
        ArrayList<Column> result = new ArrayList<Column>(dataRecord.getColumns().size());
        for (Column each : dataRecord.getColumns()) {
            if (!each.isUniqueKey() && !shardingColumns.contains(each.getName())) continue;
            result.add(each);
        }
        Optional<Column> uniqueKeyColumn = dataRecord.getColumns().stream().filter(Column::isUniqueKey).findFirst();
        if (uniqueKeyColumn.isPresent()) {
            return result;
        }
        return dataRecord.getColumns();
    }

    @Generated
    private RecordUtils() {
    }
}

