/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.preparer.inventory.calculator.position.exact;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.query.Range;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.type.pk.UniqueKeyIngestPosition;
import org.apache.shardingsphere.data.pipeline.core.preparer.inventory.calculator.position.exact.DataTypePositionHandler;

public final class IntegerPositionHandler
implements DataTypePositionHandler<BigInteger> {
    @Override
    public BigInteger readColumnValue(ResultSet resultSet, int columnIndex) throws SQLException {
        BigDecimal decimal = resultSet.getBigDecimal(columnIndex);
        return null == decimal ? null : decimal.toBigInteger();
    }

    @Override
    public void setPreparedStatementValue(PreparedStatement preparedStatement, int parameterIndex, BigInteger value) throws SQLException {
        preparedStatement.setBigDecimal(parameterIndex, new BigDecimal(value));
    }

    @Override
    public UniqueKeyIngestPosition<BigInteger> createIngestPosition(Range<BigInteger> range) {
        return UniqueKeyIngestPosition.ofInteger(range);
    }
}

