/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.preparer.inventory.calculator.position.exact;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.datasource.PipelineDataSource;
import org.apache.shardingsphere.data.pipeline.core.exception.job.SplitPipelineJobByUniqueKeyException;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.query.Range;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.IngestPosition;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.type.pk.UniqueKeyIngestPosition;
import org.apache.shardingsphere.data.pipeline.core.preparer.inventory.calculator.position.exact.DataTypePositionHandler;
import org.apache.shardingsphere.data.pipeline.core.sqlbuilder.sql.PipelinePrepareSQLBuilder;
import org.apache.shardingsphere.infra.metadata.database.schema.QualifiedTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InventoryPositionExactCalculator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InventoryPositionExactCalculator.class);

    public static <T> List<IngestPosition> getPositions(QualifiedTable qualifiedTable, String uniqueKey, int shardingSize, PipelineDataSource dataSource, DataTypePositionHandler<T> positionHandler) {
        LinkedList<IngestPosition> result = new LinkedList<IngestPosition>();
        UniqueKeyIngestPosition<T> firstPosition = InventoryPositionExactCalculator.getFirstPosition(qualifiedTable, uniqueKey, shardingSize, dataSource, positionHandler);
        result.add(firstPosition);
        result.addAll(InventoryPositionExactCalculator.getLeftPositions(qualifiedTable, uniqueKey, shardingSize, firstPosition, dataSource, positionHandler));
        return result;
    }

    /*
     * Exception decompiling
     */
    private static <T> UniqueKeyIngestPosition<T> getFirstPosition(QualifiedTable qualifiedTable, String uniqueKey, int shardingSize, PipelineDataSource dataSource, DataTypePositionHandler<T> positionHandler) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 8 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static <T> List<IngestPosition> getLeftPositions(QualifiedTable qualifiedTable, String uniqueKey, int shardingSize, UniqueKeyIngestPosition<T> firstPosition, PipelineDataSource dataSource, DataTypePositionHandler<T> positionHandler) {
        LinkedList<IngestPosition> result = new LinkedList<IngestPosition>();
        T lowerBound = firstPosition.getUpperBound();
        long recordsCount = 0L;
        String laterQuerySQL = new PipelinePrepareSQLBuilder(dataSource.getDatabaseType()).buildSplitByUniqueKeyRangedSQL(qualifiedTable.getSchemaName(), qualifiedTable.getTableName(), uniqueKey, true);
        try (Connection connection = dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(laterQuerySQL);){
            for (int i = 0; i < Integer.MAX_VALUE; ++i) {
                positionHandler.setPreparedStatementValue(preparedStatement, 1, lowerBound);
                preparedStatement.setLong(2, shardingSize);
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    if (!resultSet.next()) break;
                    int count = resultSet.getInt(2);
                    if (0 == count) {
                        log.info("Done. Later records count: {}, last lower bound: {}, sharding size: {}, later query SQL: {}", new Object[]{recordsCount, lowerBound, shardingSize, laterQuerySQL});
                        break;
                    }
                    recordsCount += (long)count;
                    T minValue = positionHandler.readColumnValue(resultSet, 3);
                    T maxValue = positionHandler.readColumnValue(resultSet, 1);
                    result.add(positionHandler.createIngestPosition(Range.closed(minValue, maxValue)));
                    lowerBound = maxValue;
                    continue;
                }
            }
        }
        catch (SQLException ex) {
            throw new SplitPipelineJobByUniqueKeyException(qualifiedTable, uniqueKey, ex);
        }
        return result;
    }
}

