/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.task;

import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.channel.PipelineChannelAckCallback;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.type.placeholder.IngestPlaceholderPosition;
import org.apache.shardingsphere.data.pipeline.core.ingest.record.DataRecord;
import org.apache.shardingsphere.data.pipeline.core.ingest.record.Record;
import org.apache.shardingsphere.data.pipeline.core.task.progress.IncrementalTaskProgress;

public final class IncrementalTaskAckCallback
implements PipelineChannelAckCallback {
    private final IncrementalTaskProgress progress;

    @Override
    public void onAck(List<Record> records) {
        Record lastHandledRecord = records.get(records.size() - 1);
        if (!(lastHandledRecord.getPosition() instanceof IngestPlaceholderPosition)) {
            this.progress.setPosition(lastHandledRecord.getPosition());
            this.progress.getIncrementalTaskDelay().setLastEventTimestamps(lastHandledRecord.getCommitTime());
        }
        if (!records.isEmpty()) {
            if (records.stream().anyMatch(DataRecord.class::isInstance)) {
                this.progress.getIncrementalTaskDelay().setLatestActiveTimeMillis(System.currentTimeMillis());
            }
        }
    }

    @Generated
    public IncrementalTaskAckCallback(IncrementalTaskProgress progress) {
        this.progress = progress;
    }
}

