/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.task;

import java.sql.SQLException;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.exception.PipelineJobCancelingException;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.InventoryDumperContext;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.IngestPosition;
import org.apache.shardingsphere.data.pipeline.core.job.progress.TransmissionJobItemProgress;
import org.apache.shardingsphere.data.pipeline.core.task.progress.IncrementalTaskProgress;
import org.apache.shardingsphere.infra.exception.external.sql.type.kernel.category.PipelineSQLException;
import org.apache.shardingsphere.infra.exception.external.sql.type.wrapper.SQLWrapperException;

public final class PipelineTaskUtils {
    public static String generateInventoryTaskId(InventoryDumperContext dumperContext) {
        return String.format("%s.%s#%s", dumperContext.getCommonContext().getDataSourceName(), dumperContext.getActualTableName(), dumperContext.getShardingItem());
    }

    public static IncrementalTaskProgress createIncrementalTaskProgress(IngestPosition position, TransmissionJobItemProgress initProgress) {
        IncrementalTaskProgress result = new IncrementalTaskProgress(position);
        if (null != initProgress && null != initProgress.getIncremental()) {
            Optional.ofNullable(initProgress.getIncremental().getIncrementalTaskProgress()).ifPresent(optional -> result.setIncrementalTaskDelay(initProgress.getIncremental().getIncrementalTaskProgress().getIncrementalTaskDelay()));
        }
        return result;
    }

    public static <T> T waitFuture(Future<T> future) {
        try {
            return future.get();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new SQLWrapperException(new SQLException(ex));
        }
        catch (ExecutionException ex) {
            if (ex.getCause() instanceof PipelineSQLException || ex.getCause() instanceof PipelineJobCancelingException) {
                throw (PipelineSQLException)ex.getCause();
            }
            throw new SQLWrapperException(new SQLException(ex));
        }
    }

    @Generated
    private PipelineTaskUtils() {
    }
}

