/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.util;

import com.google.common.base.Strings;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang3.concurrent.LazyInitializer;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineContextKey;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineContextManager;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PipelineDistributedBarrier {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PipelineDistributedBarrier.class);
    private static final Map<PipelineContextKey, PipelineDistributedBarrier> INSTANCE_MAP = new ConcurrentHashMap<PipelineContextKey, PipelineDistributedBarrier>();
    private final PipelineContextKey contextKey;
    private final LazyInitializer<ClusterPersistRepository> repositoryLazyInitializer = new PersistRepositoryLazyInitializer();
    private final Map<String, InnerCountDownLatchHolder> countDownLatchHolders = new ConcurrentHashMap<String, InnerCountDownLatchHolder>();

    public static PipelineDistributedBarrier getInstance(PipelineContextKey contextKey) {
        PipelineDistributedBarrier result = INSTANCE_MAP.get(contextKey);
        if (null != result) {
            return result;
        }
        INSTANCE_MAP.computeIfAbsent(contextKey, PipelineDistributedBarrier::new);
        return INSTANCE_MAP.get(contextKey);
    }

    private ClusterPersistRepository getRepository() {
        return (ClusterPersistRepository)this.repositoryLazyInitializer.get();
    }

    public void register(String barrierPath, int totalCount) {
        log.info("Register, barrier path: {}, total count: {}", (Object)barrierPath, (Object)totalCount);
        this.getRepository().persist(barrierPath, "");
        this.countDownLatchHolders.computeIfAbsent(barrierPath, key -> new InnerCountDownLatchHolder(totalCount));
    }

    public void persistEphemeralChildrenNode(String barrierPath, int shardingItem) {
        if (!this.getRepository().isExisted(barrierPath)) {
            log.info("Persist ephemeral children node, barrier path not existed: {}, sharding item: {}", (Object)barrierPath, (Object)shardingItem);
            return;
        }
        log.info("Persist ephemeral children node, barrier path: {}, sharding item: {}", (Object)barrierPath, (Object)shardingItem);
        String key = String.join((CharSequence)"/", barrierPath, Integer.toString(shardingItem));
        this.getRepository().delete(key);
        this.getRepository().persistEphemeral(key, "");
    }

    public void unregister(String barrierPath) {
        log.info("Unregister, barrier path: {}", (Object)barrierPath);
        this.getRepository().delete(barrierPath);
        InnerCountDownLatchHolder holder = this.countDownLatchHolders.remove(barrierPath);
        if (null != holder) {
            holder.releaseLatch();
        }
    }

    public boolean await(String barrierPath, long timeout, TimeUnit timeUnit) {
        InnerCountDownLatchHolder holder = this.countDownLatchHolders.get(barrierPath);
        if (null == holder) {
            log.info("Await failed, barrier path not registered: {}", (Object)barrierPath);
            return false;
        }
        try {
            boolean result = holder.awaitLatchReleasing(timeout, timeUnit);
            if (result) {
                log.info("Await success, barrier path: {}", (Object)barrierPath);
            } else {
                log.warn("Await timeout, barrier path: {}, timeout: {}, time unit: {}", new Object[]{barrierPath, timeout, timeUnit});
            }
            return result;
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public void notifyChildrenNodeCountCheck(String nodePath) {
        if (Strings.isNullOrEmpty((String)nodePath)) {
            log.info("Notify children node count check, node path is null or empty");
            return;
        }
        String barrierPath = nodePath.substring(0, nodePath.lastIndexOf(47));
        InnerCountDownLatchHolder holder = this.countDownLatchHolders.get(barrierPath);
        if (null != holder) {
            int childrenSize = this.getRepository().getChildrenKeys(barrierPath).size();
            log.info("Notify children node count check, barrier path: {}, children size: {}, total count: {}", new Object[]{barrierPath, childrenSize, holder.getTotalCount()});
            if (childrenSize == holder.getTotalCount()) {
                holder.releaseLatch();
            }
        }
    }

    @Generated
    private PipelineDistributedBarrier(PipelineContextKey contextKey) {
        this.contextKey = contextKey;
    }

    private static final class InnerCountDownLatchHolder {
        private final int totalCount;
        private final CountDownLatch countDownLatch = new CountDownLatch(1);

        public boolean awaitLatchReleasing(long timeout, TimeUnit timeUnit) throws InterruptedException {
            return this.countDownLatch.await(timeout, timeUnit);
        }

        public void releaseLatch() {
            this.countDownLatch.countDown();
        }

        @Generated
        public InnerCountDownLatchHolder(int totalCount) {
            this.totalCount = totalCount;
        }

        @Generated
        public int getTotalCount() {
            return this.totalCount;
        }
    }

    private class PersistRepositoryLazyInitializer
    extends LazyInitializer<ClusterPersistRepository> {
        private PersistRepositoryLazyInitializer() {
        }

        protected ClusterPersistRepository initialize() {
            return (ClusterPersistRepository)PipelineContextManager.getContext(PipelineDistributedBarrier.this.contextKey).getPersistServiceFacade().getRepository();
        }
    }
}

