/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.opengauss.handler.admin;

import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.type.dml.SelectStatementContext;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminExecutor;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminExecutorCreator;
import org.apache.shardingsphere.proxy.backend.opengauss.handler.admin.executor.OpenGaussShowVariableExecutor;
import org.apache.shardingsphere.proxy.backend.opengauss.handler.admin.factory.OpenGaussSelectAdminExecutorFactory;
import org.apache.shardingsphere.proxy.backend.postgresql.handler.admin.PostgreSQLAdminExecutorCreator;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dal.ShowStatement;

public final class OpenGaussAdminExecutorCreator
implements DatabaseAdminExecutorCreator {
    private final PostgreSQLAdminExecutorCreator delegate = new PostgreSQLAdminExecutorCreator();

    public Optional<DatabaseAdminExecutor> create(SQLStatementContext sqlStatementContext, String sql, String databaseName, List<Object> parameters) {
        if (sqlStatementContext instanceof SelectStatementContext) {
            return OpenGaussSelectAdminExecutorFactory.newInstance((SelectStatementContext)sqlStatementContext, sql, parameters);
        }
        if (sqlStatementContext.getSqlStatement() instanceof ShowStatement) {
            return Optional.of(new OpenGaussShowVariableExecutor((ShowStatement)sqlStatementContext.getSqlStatement()));
        }
        return this.delegate.create(sqlStatementContext, sql, databaseName, parameters);
    }

    public String getDatabaseType() {
        return "openGauss";
    }
}

