/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.engine.doris.visitor.statement.type;

import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.statement.type.TCLStatementVisitor;
import org.apache.shardingsphere.sql.parser.autogen.DorisStatementParser;
import org.apache.shardingsphere.sql.parser.engine.doris.visitor.statement.DorisStatementVisitor;
import org.apache.shardingsphere.sql.parser.statement.core.enums.OperationScope;
import org.apache.shardingsphere.sql.parser.statement.core.enums.TransactionAccessType;
import org.apache.shardingsphere.sql.parser.statement.core.enums.TransactionIsolationLevel;
import org.apache.shardingsphere.sql.parser.statement.core.segment.tcl.AutoCommitSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.BeginTransactionStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.CommitStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.ReleaseSavepointStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.RollbackStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.SavepointStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.SetAutoCommitStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.SetTransactionStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.xa.XABeginStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.xa.XACommitStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.xa.XAEndStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.xa.XAPrepareStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.xa.XARecoveryStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.xa.XARollbackStatement;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class DorisTCLStatementVisitor
extends DorisStatementVisitor
implements TCLStatementVisitor {
    public DorisTCLStatementVisitor(DatabaseType databaseType) {
        super(databaseType);
    }

    @Override
    public ASTNode visitSetTransaction(DorisStatementParser.SetTransactionContext ctx) {
        return new SetTransactionStatement(this.getDatabaseType(), this.getOperationScope(ctx.optionType()), this.getTransactionIsolationLevel(null == ctx.transactionCharacteristics().isolationLevel() ? null : ctx.transactionCharacteristics().isolationLevel().isolationTypes()), this.getTransactionAccessType(ctx.transactionCharacteristics().transactionAccessMode()));
    }

    private OperationScope getOperationScope(DorisStatementParser.OptionTypeContext ctx) {
        if (null == ctx) {
            return null;
        }
        if (null != ctx.SESSION()) {
            return OperationScope.SESSION;
        }
        if (null != ctx.GLOBAL()) {
            return OperationScope.GLOBAL;
        }
        return null;
    }

    private TransactionIsolationLevel getTransactionIsolationLevel(DorisStatementParser.IsolationTypesContext ctx) {
        if (null == ctx) {
            return null;
        }
        if (null != ctx.SERIALIZABLE()) {
            return TransactionIsolationLevel.SERIALIZABLE;
        }
        if (null != ctx.COMMITTED()) {
            return TransactionIsolationLevel.READ_COMMITTED;
        }
        if (null != ctx.UNCOMMITTED()) {
            return TransactionIsolationLevel.READ_UNCOMMITTED;
        }
        if (null != ctx.REPEATABLE()) {
            return TransactionIsolationLevel.REPEATABLE_READ;
        }
        return null;
    }

    private TransactionAccessType getTransactionAccessType(DorisStatementParser.TransactionAccessModeContext ctx) {
        if (null == ctx) {
            return null;
        }
        if (null != ctx.ONLY()) {
            return TransactionAccessType.READ_ONLY;
        }
        if (null != ctx.WRITE()) {
            return TransactionAccessType.READ_WRITE;
        }
        return null;
    }

    @Override
    public ASTNode visitSetAutoCommit(DorisStatementParser.SetAutoCommitContext ctx) {
        return new SetAutoCommitStatement(this.getDatabaseType(), this.generateAutoCommitSegment(ctx.autoCommitValue).isAutoCommit());
    }

    private AutoCommitSegment generateAutoCommitSegment(Token ctx) {
        boolean autoCommit = "1".equals(ctx.getText()) || "ON".equals(ctx.getText());
        return new AutoCommitSegment(ctx.getStartIndex(), ctx.getStopIndex(), autoCommit);
    }

    @Override
    public ASTNode visitBeginTransaction(DorisStatementParser.BeginTransactionContext ctx) {
        return new BeginTransactionStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCommit(DorisStatementParser.CommitContext ctx) {
        return new CommitStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitRollback(DorisStatementParser.RollbackContext ctx) {
        return null == ctx.identifier() ? new RollbackStatement(this.getDatabaseType()) : new RollbackStatement(this.getDatabaseType(), ((IdentifierValue)this.visit((ParseTree)ctx.identifier())).getValue());
    }

    @Override
    public ASTNode visitSavepoint(DorisStatementParser.SavepointContext ctx) {
        return new SavepointStatement(this.getDatabaseType(), ((IdentifierValue)this.visit((ParseTree)ctx.identifier())).getValue());
    }

    @Override
    public ASTNode visitReleaseSavepoint(DorisStatementParser.ReleaseSavepointContext ctx) {
        return new ReleaseSavepointStatement(this.getDatabaseType(), ((IdentifierValue)this.visit((ParseTree)ctx.identifier())).getValue());
    }

    @Override
    public ASTNode visitXaBegin(DorisStatementParser.XaBeginContext ctx) {
        return new XABeginStatement(this.getDatabaseType(), ctx.xid().getText());
    }

    @Override
    public ASTNode visitXaPrepare(DorisStatementParser.XaPrepareContext ctx) {
        return new XAPrepareStatement(this.getDatabaseType(), ctx.xid().getText());
    }

    @Override
    public ASTNode visitXaCommit(DorisStatementParser.XaCommitContext ctx) {
        return new XACommitStatement(this.getDatabaseType(), ctx.xid().getText());
    }

    @Override
    public ASTNode visitXaRollback(DorisStatementParser.XaRollbackContext ctx) {
        return new XARollbackStatement(this.getDatabaseType(), ctx.xid().getText());
    }

    @Override
    public ASTNode visitXaEnd(DorisStatementParser.XaEndContext ctx) {
        return new XAEndStatement(this.getDatabaseType(), ctx.xid().getText());
    }

    @Override
    public ASTNode visitXaRecovery(DorisStatementParser.XaRecoveryContext ctx) {
        return new XARecoveryStatement(this.getDatabaseType());
    }
}

