/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.agent.core;

import java.io.File;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.util.Collection;
import java.util.Map;
import java.util.jar.JarFile;
import lombok.Generated;
import org.apache.shardingsphere.agent.api.PluginConfiguration;
import org.apache.shardingsphere.agent.core.advisor.config.AdvisorConfiguration;
import org.apache.shardingsphere.agent.core.advisor.config.AdvisorConfigurationLoader;
import org.apache.shardingsphere.agent.core.builder.AgentBuilderFactory;
import org.apache.shardingsphere.agent.core.path.AgentPath;
import org.apache.shardingsphere.agent.core.plugin.config.PluginConfigurationLoader;
import org.apache.shardingsphere.agent.core.plugin.jar.PluginJarLoader;
import org.apache.shardingsphere.shade.net.bytebuddy.pool.TypePool;

public final class ShardingSphereAgent {
    public static void premain(String args, Instrumentation instrumentation) throws IOException {
        File rootPath = AgentPath.getRootPath();
        Map<String, PluginConfiguration> pluginConfigs = PluginConfigurationLoader.load(rootPath);
        Collection<JarFile> pluginJars = PluginJarLoader.load(rootPath);
        Map<String, AdvisorConfiguration> advisorConfigs = AdvisorConfigurationLoader.load(pluginJars, pluginConfigs.keySet());
        AgentBuilderFactory.create(pluginConfigs, pluginJars, advisorConfigs, ShardingSphereAgent.isEnhancedForProxy()).installOn(instrumentation);
    }

    private static boolean isEnhancedForProxy() {
        return TypePool.Default.ofSystemLoader().describe("org.apache.shardingsphere.proxy.Bootstrap").isResolved();
    }

    @Generated
    private ShardingSphereAgent() {
    }
}

