/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.parser.cache;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.parser.cache.CacheManager;
import org.apache.shardingsphere.infra.parser.cache.SQLStatementCacheLoader;
import org.apache.shardingsphere.sql.parser.engine.api.CacheOption;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;

public final class SQLStatementCacheBuilder {
    public static CacheManager<String, SQLStatement> build(DatabaseType databaseType, CacheOption sqlStatementCacheOption, CacheOption parseTreeCacheOption) {
        SQLStatementCacheLoader sqlStatementCacheLoader = new SQLStatementCacheLoader(databaseType, parseTreeCacheOption);
        LoadingCache loadingCache = Caffeine.newBuilder().softValues().initialCapacity(sqlStatementCacheOption.getInitialCapacity()).maximumSize(sqlStatementCacheOption.getMaximumSize()).build((CacheLoader)sqlStatementCacheLoader);
        return new CacheManager<String, SQLStatement>(loadingCache, sqlStatementCacheLoader);
    }

    @Generated
    private SQLStatementCacheBuilder() {
    }
}

