/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.broadcast.rule.changed;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import org.apache.shardingsphere.broadcast.config.BroadcastRuleConfiguration;
import org.apache.shardingsphere.broadcast.rule.BroadcastRule;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.mode.spi.rule.RuleChangedItemType;
import org.apache.shardingsphere.mode.spi.rule.RuleItemConfigurationChangedProcessor;

public class BroadcastRuleChangedProcessor
implements RuleItemConfigurationChangedProcessor<BroadcastRuleConfiguration, BroadcastRuleConfiguration> {
    public BroadcastRuleConfiguration swapRuleItemConfiguration(String itemName, String yamlContent) {
        return new BroadcastRuleConfiguration((Collection)YamlEngine.unmarshal((String)yamlContent, LinkedHashSet.class));
    }

    public BroadcastRuleConfiguration findRuleConfiguration(ShardingSphereDatabase database) {
        return database.getRuleMetaData().findSingleRule(BroadcastRule.class).map(BroadcastRule::getConfiguration).orElseGet(() -> new BroadcastRuleConfiguration(new LinkedList()));
    }

    public void changeRuleItemConfiguration(String itemName, BroadcastRuleConfiguration currentRuleConfig, BroadcastRuleConfiguration toBeChangedItemConfig) {
        currentRuleConfig.getTables().clear();
        currentRuleConfig.getTables().addAll(toBeChangedItemConfig.getTables());
    }

    public void dropRuleItemConfiguration(String itemName, BroadcastRuleConfiguration currentRuleConfig) {
        currentRuleConfig.getTables().clear();
    }

    public RuleChangedItemType getType() {
        return new RuleChangedItemType("broadcast", null);
    }
}

