/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.exporter.otlp.metrics;

import io.grpc.ManagedChannel;
import java.net.URI;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;
import org.apache.shardingsphere.shade.io.opentelemetry.api.internal.Utils;
import org.apache.shardingsphere.shade.io.opentelemetry.api.metrics.MeterProvider;
import org.apache.shardingsphere.shade.io.opentelemetry.common.ComponentLoader;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.grpc.GrpcExporterBuilder;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.Marshaler;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.otlp.internal.OtlpUserAgent;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.otlp.metrics.MarshalerMetricsServiceGrpc;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporter;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.common.InternalTelemetryVersion;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.common.export.MemoryMode;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.common.export.RetryPolicy;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.internal.StandardComponentId;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.export.AggregationTemporalitySelector;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.export.DefaultAggregationSelector;

public final class OtlpGrpcMetricExporterBuilder {
    private static final String GRPC_SERVICE_NAME = "opentelemetry.proto.collector.metrics.v1.MetricsService";
    static final String GRPC_ENDPOINT_PATH = "/opentelemetry.proto.collector.metrics.v1.MetricsService/Export";
    private static final String DEFAULT_ENDPOINT_URL = "http://localhost:4317";
    private static final URI DEFAULT_ENDPOINT = URI.create("http://localhost:4317");
    private static final long DEFAULT_TIMEOUT_SECS = 10L;
    private static final AggregationTemporalitySelector DEFAULT_AGGREGATION_TEMPORALITY_SELECTOR = AggregationTemporalitySelector.alwaysCumulative();
    private static final MemoryMode DEFAULT_MEMORY_MODE = MemoryMode.REUSABLE_DATA;
    final GrpcExporterBuilder<Marshaler> delegate;
    private AggregationTemporalitySelector aggregationTemporalitySelector;
    private DefaultAggregationSelector defaultAggregationSelector;
    private MemoryMode memoryMode;

    OtlpGrpcMetricExporterBuilder(GrpcExporterBuilder<Marshaler> delegate, AggregationTemporalitySelector aggregationTemporalitySelector, DefaultAggregationSelector defaultAggregationSelector, MemoryMode memoryMode) {
        this.delegate = delegate;
        this.aggregationTemporalitySelector = aggregationTemporalitySelector;
        this.defaultAggregationSelector = defaultAggregationSelector;
        this.memoryMode = memoryMode;
        OtlpUserAgent.addUserAgentHeader(delegate::addConstantHeader);
    }

    OtlpGrpcMetricExporterBuilder() {
        this(new GrpcExporterBuilder<Marshaler>(StandardComponentId.ExporterType.OTLP_GRPC_METRIC_EXPORTER, 10L, DEFAULT_ENDPOINT, () -> MarshalerMetricsServiceGrpc::newFutureStub, GRPC_ENDPOINT_PATH), DEFAULT_AGGREGATION_TEMPORALITY_SELECTOR, DefaultAggregationSelector.getDefault(), DEFAULT_MEMORY_MODE);
    }

    @Deprecated
    public OtlpGrpcMetricExporterBuilder setChannel(ManagedChannel channel) {
        this.delegate.setChannel(channel);
        return this;
    }

    public OtlpGrpcMetricExporterBuilder setTimeout(long timeout2, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        Utils.checkArgument(timeout2 >= 0L, "timeout must be non-negative");
        this.delegate.setTimeout(timeout2, unit);
        return this;
    }

    public OtlpGrpcMetricExporterBuilder setTimeout(Duration timeout2) {
        Objects.requireNonNull(timeout2, "timeout");
        this.delegate.setTimeout(timeout2);
        return this;
    }

    public OtlpGrpcMetricExporterBuilder setConnectTimeout(long timeout2, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        Utils.checkArgument(timeout2 >= 0L, "timeout must be non-negative");
        this.delegate.setConnectTimeout(timeout2, unit);
        return this;
    }

    public OtlpGrpcMetricExporterBuilder setConnectTimeout(Duration timeout2) {
        Objects.requireNonNull(timeout2, "timeout");
        return this.setConnectTimeout(timeout2.toNanos(), TimeUnit.NANOSECONDS);
    }

    public OtlpGrpcMetricExporterBuilder setEndpoint(String endpoint) {
        Objects.requireNonNull(endpoint, "endpoint");
        this.delegate.setEndpoint(endpoint);
        return this;
    }

    public OtlpGrpcMetricExporterBuilder setCompression(String compressionMethod) {
        Objects.requireNonNull(compressionMethod, "compressionMethod");
        this.delegate.setCompression(compressionMethod);
        return this;
    }

    public OtlpGrpcMetricExporterBuilder setTrustedCertificates(byte[] trustedCertificatesPem) {
        this.delegate.setTrustManagerFromCerts(trustedCertificatesPem);
        return this;
    }

    public OtlpGrpcMetricExporterBuilder setClientTls(byte[] privateKeyPem, byte[] certificatePem) {
        this.delegate.setKeyManagerFromCerts(privateKeyPem, certificatePem);
        return this;
    }

    public OtlpGrpcMetricExporterBuilder setSslContext(SSLContext sslContext, X509TrustManager trustManager) {
        this.delegate.setSslContext(sslContext, trustManager);
        return this;
    }

    public OtlpGrpcMetricExporterBuilder addHeader(String key, String value) {
        this.delegate.addConstantHeader(key, value);
        return this;
    }

    public OtlpGrpcMetricExporterBuilder setHeaders(Supplier<Map<String, String>> headerSupplier) {
        this.delegate.setHeadersSupplier(headerSupplier);
        return this;
    }

    public OtlpGrpcMetricExporterBuilder setAggregationTemporalitySelector(AggregationTemporalitySelector aggregationTemporalitySelector) {
        Objects.requireNonNull(aggregationTemporalitySelector, "aggregationTemporalitySelector");
        this.aggregationTemporalitySelector = aggregationTemporalitySelector;
        return this;
    }

    public OtlpGrpcMetricExporterBuilder setDefaultAggregationSelector(DefaultAggregationSelector defaultAggregationSelector) {
        Objects.requireNonNull(defaultAggregationSelector, "defaultAggregationSelector");
        this.defaultAggregationSelector = defaultAggregationSelector;
        return this;
    }

    public OtlpGrpcMetricExporterBuilder setRetryPolicy(@Nullable RetryPolicy retryPolicy) {
        this.delegate.setRetryPolicy(retryPolicy);
        return this;
    }

    public OtlpGrpcMetricExporterBuilder setInternalTelemetryVersion(InternalTelemetryVersion schemaVersion) {
        Objects.requireNonNull(schemaVersion, "schemaVersion");
        this.delegate.setInternalTelemetryVersion(schemaVersion);
        return this;
    }

    public OtlpGrpcMetricExporterBuilder setMeterProvider(MeterProvider meterProvider) {
        Objects.requireNonNull(meterProvider, "meterProvider");
        this.delegate.setMeterProvider(() -> meterProvider);
        return this;
    }

    public OtlpGrpcMetricExporterBuilder setMeterProvider(Supplier<MeterProvider> meterProviderSupplier) {
        Objects.requireNonNull(meterProviderSupplier, "meterProvider");
        this.delegate.setMeterProvider(meterProviderSupplier);
        return this;
    }

    public OtlpGrpcMetricExporterBuilder setMemoryMode(MemoryMode memoryMode) {
        Objects.requireNonNull(memoryMode, "memoryMode");
        this.memoryMode = memoryMode;
        return this;
    }

    public OtlpGrpcMetricExporterBuilder setServiceClassLoader(ClassLoader serviceClassLoader) {
        Objects.requireNonNull(serviceClassLoader, "serviceClassLoader");
        return this.setComponentLoader(ComponentLoader.forClassLoader(serviceClassLoader));
    }

    public OtlpGrpcMetricExporterBuilder setComponentLoader(ComponentLoader componentLoader) {
        Objects.requireNonNull(componentLoader, "componentLoader");
        this.delegate.setComponentLoader(componentLoader);
        return this;
    }

    public OtlpGrpcMetricExporterBuilder setExecutorService(ExecutorService executorService) {
        Objects.requireNonNull(executorService, "executorService");
        this.delegate.setExecutorService(executorService);
        return this;
    }

    public OtlpGrpcMetricExporter build() {
        return new OtlpGrpcMetricExporter(this.delegate, this.delegate.build(), this.aggregationTemporalitySelector, this.defaultAggregationSelector, this.memoryMode);
    }
}

