/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.engine.mysql.visitor.statement.type;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.statement.type.DALStatementVisitor;
import org.apache.shardingsphere.sql.parser.autogen.MySQLStatementParser;
import org.apache.shardingsphere.sql.parser.engine.mysql.visitor.statement.MySQLStatementVisitor;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dal.CacheTableIndexSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dal.CloneActionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dal.CloneInstanceSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dal.FromDatabaseSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dal.FromTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dal.LoadTableIndexSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dal.PartitionDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dal.PartitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dal.ResetMasterOptionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dal.ResetOptionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dal.ResetSlaveOptionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dal.ShowFilterSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dal.ShowLikeSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dal.VariableAssignSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dal.VariableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.FunctionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.pagination.limit.LimitSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.DatabaseSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dal.AnalyzeTableStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dal.ExplainStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dal.SetStatement;
import org.apache.shardingsphere.sql.parser.statement.core.value.collection.CollectionValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.literal.impl.NumberLiteralValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.literal.impl.StringLiteralValue;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.MySQLCloneStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.MySQLCreateLoadableFunctionStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.MySQLDelimiterStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.MySQLFlushStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.MySQLHelpStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.MySQLKillStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.MySQLResetPersistStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.MySQLResetStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.MySQLRestartStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.MySQLShutdownStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.MySQLUseStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.component.MySQLInstallComponentStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.component.MySQLUninstallComponentStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.index.MySQLCacheIndexStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.index.MySQLLoadIndexInfoStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.plugin.MySQLInstallPluginStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.plugin.MySQLShowPluginsStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.plugin.MySQLUninstallPluginStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.replication.binlog.MySQLBinlogStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.replication.binlog.MySQLShowBinaryLogsStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.replication.binlog.MySQLShowBinlogEventsStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.replication.opertation.MySQLChangeMasterStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.replication.opertation.MySQLChangeReplicationSourceToStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.replication.opertation.MySQLStartReplicaStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.replication.opertation.MySQLStartSlaveStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.replication.opertation.MySQLStopSlaveStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.replication.show.MySQLShowMasterStatusStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.replication.show.MySQLShowRelayLogEventsStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.replication.show.MySQLShowReplicaStatusStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.replication.show.MySQLShowReplicasStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.replication.show.MySQLShowSlaveHostsStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.replication.show.MySQLShowSlaveStatusStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.replication.show.MySQLShowStatusStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.resource.MySQLAlterResourceGroupStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.resource.MySQLCreateResourceGroupStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.resource.MySQLDropResourceGroupStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.resource.MySQLSetResourceGroupStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.MySQLShowOtherStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.character.MySQLShowCharacterSetStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.character.MySQLShowCollationStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.column.MySQLDescribeStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.column.MySQLShowColumnsStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.database.MySQLShowCreateDatabaseStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.database.MySQLShowDatabasesStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.engine.MySQLShowEngineStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.error.MySQLShowErrorsStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.error.MySQLShowWarningsStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.event.MySQLShowCreateEventStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.event.MySQLShowEventsStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.function.MySQLShowCreateFunctionStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.function.MySQLShowFunctionCodeStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.function.MySQLShowFunctionStatusStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.index.MySQLShowIndexStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.privilege.MySQLShowCreateUserStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.privilege.MySQLShowGrantsStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.privilege.MySQLShowPrivilegesStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.procedure.MySQLShowCreateProcedureStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.procedure.MySQLShowProcedureCodeStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.procedure.MySQLShowProcedureStatusStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.process.MySQLShowProcessListStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.profile.MySQLShowProfileStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.profile.MySQLShowProfilesStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.table.MySQLShowCreateTableStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.table.MySQLShowOpenTablesStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.table.MySQLShowTableStatusStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.table.MySQLShowTablesStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.trigger.MySQLShowCreateTriggerStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.trigger.MySQLShowTriggersStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.variable.MySQLShowVariablesStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.view.MySQLShowCreateViewStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.table.MySQLCheckTableStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.table.MySQLChecksumTableStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.table.MySQLOptimizeTableStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.table.MySQLRepairTableStatement;

public final class MySQLDALStatementVisitor
extends MySQLStatementVisitor
implements DALStatementVisitor {
    public MySQLDALStatementVisitor(DatabaseType databaseType) {
        super(databaseType);
    }

    @Override
    public ASTNode visitUninstallPlugin(MySQLStatementParser.UninstallPluginContext ctx) {
        return new MySQLUninstallPluginStatement(this.getDatabaseType(), ((IdentifierValue)this.visit((ParseTree)ctx.pluginName())).getValue());
    }

    @Override
    public ASTNode visitShowCreateDatabase(MySQLStatementParser.ShowCreateDatabaseContext ctx) {
        return new MySQLShowCreateDatabaseStatement(this.getDatabaseType(), ((DatabaseSegment)this.visit((ParseTree)ctx.databaseName())).getIdentifier().getValue());
    }

    @Override
    public ASTNode visitShowBinaryLogs(MySQLStatementParser.ShowBinaryLogsContext ctx) {
        return new MySQLShowBinaryLogsStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitShowStatus(MySQLStatementParser.ShowStatusContext ctx) {
        MySQLShowStatusStatement result = new MySQLShowStatusStatement(this.getDatabaseType(), null == ctx.showFilter() ? null : (ShowFilterSegment)this.visit((ParseTree)ctx.showFilter()));
        result.addParameterMarkers(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitShowCreateView(MySQLStatementParser.ShowCreateViewContext ctx) {
        return new MySQLShowCreateViewStatement(this.getDatabaseType(), (SimpleTableSegment)this.visit((ParseTree)ctx.viewName()));
    }

    @Override
    public ASTNode visitShowEngines(MySQLStatementParser.ShowEnginesContext ctx) {
        return new MySQLShowOtherStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitShowEngine(MySQLStatementParser.ShowEngineContext ctx) {
        return new MySQLShowEngineStatement(this.getDatabaseType(), ctx.engineRef().getText());
    }

    @Override
    public ASTNode visitShowCharset(MySQLStatementParser.ShowCharsetContext ctx) {
        return new MySQLShowOtherStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitShowCreateEvent(MySQLStatementParser.ShowCreateEventContext ctx) {
        return new MySQLShowCreateEventStatement(this.getDatabaseType(), ((IdentifierValue)this.visit((ParseTree)ctx.eventName())).getValue());
    }

    @Override
    public ASTNode visitShowCreateFunction(MySQLStatementParser.ShowCreateFunctionContext ctx) {
        return new MySQLShowCreateFunctionStatement(this.getDatabaseType(), ((FunctionSegment)this.visit((ParseTree)ctx.functionName())).getFunctionName());
    }

    @Override
    public ASTNode visitShowCreateProcedure(MySQLStatementParser.ShowCreateProcedureContext ctx) {
        return new MySQLShowCreateProcedureStatement(this.getDatabaseType(), ((IdentifierValue)this.visit((ParseTree)ctx.procedureName())).getValue());
    }

    @Override
    public ASTNode visitShowBinlogEvents(MySQLStatementParser.ShowBinlogEventsContext ctx) {
        return new MySQLShowBinlogEventsStatement(this.getDatabaseType(), null == ctx.logName() ? null : ctx.logName().getText(), null == ctx.limitClause() ? null : (LimitSegment)this.visit((ParseTree)ctx.limitClause()));
    }

    @Override
    public ASTNode visitShowErrors(MySQLStatementParser.ShowErrorsContext ctx) {
        return new MySQLShowErrorsStatement(this.getDatabaseType(), null == ctx.limitClause() ? null : (LimitSegment)this.visit((ParseTree)ctx.limitClause()));
    }

    @Override
    public ASTNode visitShowWarnings(MySQLStatementParser.ShowWarningsContext ctx) {
        return new MySQLShowWarningsStatement(this.getDatabaseType(), null == ctx.limitClause() ? null : (LimitSegment)this.visit((ParseTree)ctx.limitClause()));
    }

    @Override
    public ASTNode visitResetStatement(MySQLStatementParser.ResetStatementContext ctx) {
        MySQLStatementParser.ResetPersistContext persistContext = ctx.resetPersist();
        return null == persistContext ? new MySQLResetStatement(this.getDatabaseType(), ctx.resetOption().stream().filter(each -> null != each.MASTER() || null != each.SLAVE()).map(each -> (ResetOptionSegment)this.visit((ParseTree)each)).collect(Collectors.toList())) : (ASTNode)this.visit((ParseTree)persistContext);
    }

    @Override
    public ASTNode visitResetPersist(MySQLStatementParser.ResetPersistContext ctx) {
        return new MySQLResetPersistStatement(this.getDatabaseType(), null != ctx.ifExists(), null == ctx.identifier() ? null : new IdentifierValue(ctx.identifier().getText()));
    }

    @Override
    public ASTNode visitResetOption(MySQLStatementParser.ResetOptionContext ctx) {
        if (null != ctx.MASTER()) {
            ResetMasterOptionSegment result = new ResetMasterOptionSegment();
            if (null != ctx.binaryLogFileIndexNumber()) {
                result.setBinaryLogFileIndexNumber(Long.valueOf(((NumberLiteralValue)this.visit((ParseTree)ctx.binaryLogFileIndexNumber())).getValue().longValue()));
            }
            result.setStartIndex(ctx.start.getStartIndex());
            result.setStopIndex(ctx.stop.getStopIndex());
            return result;
        }
        ResetSlaveOptionSegment result = new ResetSlaveOptionSegment();
        if (null != ctx.ALL()) {
            result.setAll(true);
        }
        if (null != ctx.channelOption()) {
            result.setChannelOption(((StringLiteralValue)this.visit((ParseTree)ctx.channelOption())).getValue());
        }
        result.setStartIndex(ctx.start.getStartIndex());
        result.setStopIndex(ctx.stop.getStopIndex());
        return result;
    }

    @Override
    public ASTNode visitChannelOption(MySQLStatementParser.ChannelOptionContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.string_());
    }

    @Override
    public ASTNode visitBinaryLogFileIndexNumber(MySQLStatementParser.BinaryLogFileIndexNumberContext ctx) {
        return new NumberLiteralValue(ctx.getText());
    }

    @Override
    public ASTNode visitShowReplicas(MySQLStatementParser.ShowReplicasContext ctx) {
        return new MySQLShowReplicasStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitRepairTable(MySQLStatementParser.RepairTableContext ctx) {
        return new MySQLRepairTableStatement(this.getDatabaseType(), ((CollectionValue)this.visit((ParseTree)ctx.tableList())).getValue());
    }

    @Override
    public ASTNode visitAnalyzeTable(MySQLStatementParser.AnalyzeTableContext ctx) {
        return new AnalyzeTableStatement(this.getDatabaseType(), ((CollectionValue)this.visit((ParseTree)ctx.tableList())).getValue());
    }

    @Override
    public ASTNode visitCacheIndex(MySQLStatementParser.CacheIndexContext ctx) {
        IdentifierValue name = null == ctx.DEFAULT() ? (IdentifierValue)this.visit((ParseTree)ctx.identifier()) : new IdentifierValue(ctx.DEFAULT().getText());
        List tableIndexes = null == ctx.cacheTableIndexList() ? Collections.emptyList() : (Collection)ctx.cacheTableIndexList().stream().map(each -> (CacheTableIndexSegment)this.visit((ParseTree)each)).collect(Collectors.toList());
        PartitionDefinitionSegment partitionDefinition = null == ctx.partitionList() ? null : new PartitionDefinitionSegment(ctx.tableName().getStart().getStartIndex(), ctx.partitionList().getStop().getStopIndex(), (SimpleTableSegment)this.visit((ParseTree)ctx.tableName()), ((CollectionValue)this.visit((ParseTree)ctx.partitionList())).getValue());
        return new MySQLCacheIndexStatement(this.getDatabaseType(), name, tableIndexes, partitionDefinition);
    }

    @Override
    public ASTNode visitCacheTableIndexList(MySQLStatementParser.CacheTableIndexListContext ctx) {
        CacheTableIndexSegment result = new CacheTableIndexSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        for (MySQLStatementParser.IndexNameContext each : ctx.indexName()) {
            result.getIndexes().add((IndexSegment)this.visitIndexName(each));
        }
        return result;
    }

    @Override
    public ASTNode visitPartitionList(MySQLStatementParser.PartitionListContext ctx) {
        CollectionValue result = new CollectionValue();
        for (MySQLStatementParser.PartitionNameContext each : ctx.partitionName()) {
            result.getValue().add((PartitionSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitPartitionName(MySQLStatementParser.PartitionNameContext ctx) {
        return new PartitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.identifier()));
    }

    @Override
    public ASTNode visitChecksumTable(MySQLStatementParser.ChecksumTableContext ctx) {
        return new MySQLChecksumTableStatement(this.getDatabaseType(), ((CollectionValue)this.visit((ParseTree)ctx.tableList())).getValue());
    }

    @Override
    public ASTNode visitFlush(MySQLStatementParser.FlushContext ctx) {
        if (null != ctx.tablesOption()) {
            return (ASTNode)this.visit((ParseTree)ctx.tablesOption());
        }
        return new MySQLFlushStatement(this.getDatabaseType(), Collections.emptyList(), false);
    }

    @Override
    public ASTNode visitTablesOption(MySQLStatementParser.TablesOptionContext ctx) {
        return new MySQLFlushStatement(this.getDatabaseType(), (Collection)ctx.tableName().stream().map(each -> (SimpleTableSegment)this.visit((ParseTree)each)).collect(Collectors.toList()), true);
    }

    @Override
    public ASTNode visitKill(MySQLStatementParser.KillContext ctx) {
        return new MySQLKillStatement(this.getDatabaseType(), null == ctx.AT_() ? ctx.IDENTIFIER_().getText() : ctx.AT_().getText() + ctx.IDENTIFIER_().getText(), this.getScope(ctx));
    }

    private String getScope(MySQLStatementParser.KillContext ctx) {
        if (null != ctx.QUERY()) {
            return ctx.QUERY().getText();
        }
        if (null != ctx.CONNECTION()) {
            return ctx.CONNECTION().getText();
        }
        return null;
    }

    @Override
    public ASTNode visitLoadIndexInfo(MySQLStatementParser.LoadIndexInfoContext ctx) {
        return new MySQLLoadIndexInfoStatement(this.getDatabaseType(), (Collection)ctx.loadTableIndexList().stream().map(each -> (LoadTableIndexSegment)this.visit((ParseTree)each)).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitLoadTableIndexList(MySQLStatementParser.LoadTableIndexListContext ctx) {
        LoadTableIndexSegment result = new LoadTableIndexSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        if (null != ctx.indexName()) {
            for (MySQLStatementParser.IndexNameContext each : ctx.indexName()) {
                result.getIndexes().add((IndexSegment)this.visitIndexName(each));
            }
        }
        if (null != ctx.partitionList()) {
            result.getPartitions().addAll(((CollectionValue)this.visit((ParseTree)ctx.partitionList())).getValue());
        }
        return result;
    }

    @Override
    public ASTNode visitInstallPlugin(MySQLStatementParser.InstallPluginContext ctx) {
        return new MySQLInstallPluginStatement(this.getDatabaseType(), ((IdentifierValue)this.visit((ParseTree)ctx.pluginName())).getValue());
    }

    @Override
    public ASTNode visitClone(MySQLStatementParser.CloneContext ctx) {
        return new MySQLCloneStatement(this.getDatabaseType(), (CloneActionSegment)this.visit((ParseTree)ctx.cloneAction()));
    }

    @Override
    public ASTNode visitCloneAction(MySQLStatementParser.CloneActionContext ctx) {
        CloneActionSegment result = new CloneActionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        if (null != ctx.cloneInstance()) {
            MySQLStatementParser.CloneInstanceContext cloneInstance = ctx.cloneInstance();
            CloneInstanceSegment cloneInstanceSegment = new CloneInstanceSegment(cloneInstance.start.getStartIndex(), cloneInstance.stop.getStopIndex());
            cloneInstanceSegment.setUsername(((StringLiteralValue)this.visitUsername(cloneInstance.username())).getValue());
            cloneInstanceSegment.setHostname(((StringLiteralValue)this.visit((ParseTree)cloneInstance.hostname())).getValue());
            cloneInstanceSegment.setPort(new NumberLiteralValue(cloneInstance.port().NUMBER_().getText()).getValue().intValue());
            cloneInstanceSegment.setPassword(((StringLiteralValue)this.visit((ParseTree)ctx.string_())).getValue());
            if (null != ctx.SSL() && null == ctx.NO()) {
                cloneInstanceSegment.setSslRequired(true);
            }
            result.setCloneInstance(cloneInstanceSegment);
        }
        if (null != ctx.cloneDir()) {
            result.setCloneDir(((StringLiteralValue)this.visit((ParseTree)ctx.cloneDir())).getValue());
        }
        return result;
    }

    @Override
    public ASTNode visitOptimizeTable(MySQLStatementParser.OptimizeTableContext ctx) {
        return new MySQLOptimizeTableStatement(this.getDatabaseType(), ((CollectionValue)this.visit((ParseTree)ctx.tableList())).getValue());
    }

    @Override
    public ASTNode visitUse(MySQLStatementParser.UseContext ctx) {
        return new MySQLUseStatement(this.getDatabaseType(), ((DatabaseSegment)this.visit((ParseTree)ctx.databaseName())).getIdentifier().getValue());
    }

    @Override
    public ASTNode visitExplain(MySQLStatementParser.ExplainContext ctx) {
        return null == ctx.tableName() ? new ExplainStatement(this.getDatabaseType(), (SQLStatement)this.getExplainableSQLStatement(ctx).orElse(null)) : new MySQLDescribeStatement(this.getDatabaseType(), (SimpleTableSegment)this.visit((ParseTree)ctx.tableName()), this.getColumnWildcard(ctx));
    }

    private Optional<SQLStatement> getExplainableSQLStatement(MySQLStatementParser.ExplainContext ctx) {
        if (null != ctx.explainableStatement()) {
            return Optional.of((SQLStatement)this.visit((ParseTree)ctx.explainableStatement()));
        }
        if (null != ctx.select()) {
            return Optional.of((SQLStatement)this.visit((ParseTree)ctx.select()));
        }
        if (null != ctx.delete()) {
            return Optional.of((SQLStatement)this.visit((ParseTree)ctx.delete()));
        }
        if (null != ctx.update()) {
            return Optional.of((SQLStatement)this.visit((ParseTree)ctx.update()));
        }
        if (null != ctx.insert()) {
            return Optional.of((SQLStatement)this.visit((ParseTree)ctx.insert()));
        }
        return Optional.empty();
    }

    private ColumnSegment getColumnWildcard(MySQLStatementParser.ExplainContext ctx) {
        if (null != ctx.columnRef()) {
            return (ColumnSegment)this.visit((ParseTree)ctx.columnRef());
        }
        if (null != ctx.textString()) {
            return (ColumnSegment)this.visit((ParseTree)ctx.textString());
        }
        return null;
    }

    @Override
    public ASTNode visitExplainableStatement(MySQLStatementParser.ExplainableStatementContext ctx) {
        if (null != ctx.select()) {
            return (ASTNode)this.visit((ParseTree)ctx.select());
        }
        if (null != ctx.delete()) {
            return (ASTNode)this.visit((ParseTree)ctx.delete());
        }
        if (null != ctx.insert()) {
            return (ASTNode)this.visit((ParseTree)ctx.insert());
        }
        if (null != ctx.replace()) {
            return (ASTNode)this.visit((ParseTree)ctx.replace());
        }
        return (ASTNode)this.visit((ParseTree)ctx.update());
    }

    @Override
    public ASTNode visitShowProcedureCode(MySQLStatementParser.ShowProcedureCodeContext ctx) {
        return new MySQLShowProcedureCodeStatement(this.getDatabaseType(), (FunctionSegment)this.visit((ParseTree)ctx.functionName()));
    }

    @Override
    public ASTNode visitShowProfile(MySQLStatementParser.ShowProfileContext ctx) {
        return new MySQLShowProfileStatement(this.getDatabaseType(), null == ctx.limitClause() ? null : (LimitSegment)this.visit((ParseTree)ctx.limitClause()));
    }

    @Override
    public ASTNode visitShowProfiles(MySQLStatementParser.ShowProfilesContext ctx) {
        return new MySQLShowProfilesStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitShowDatabases(MySQLStatementParser.ShowDatabasesContext ctx) {
        MySQLShowDatabasesStatement result = new MySQLShowDatabasesStatement(this.getDatabaseType(), null == ctx.showFilter() ? null : (ShowFilterSegment)this.visit((ParseTree)ctx.showFilter()));
        result.addParameterMarkers(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitShowEvents(MySQLStatementParser.ShowEventsContext ctx) {
        MySQLShowEventsStatement result = new MySQLShowEventsStatement(this.getDatabaseType(), null == ctx.fromDatabase() ? null : (FromDatabaseSegment)this.visit((ParseTree)ctx.fromDatabase()), null == ctx.showFilter() ? null : (ShowFilterSegment)this.visit((ParseTree)ctx.showFilter()));
        result.addParameterMarkers(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitShowTables(MySQLStatementParser.ShowTablesContext ctx) {
        MySQLShowTablesStatement result = new MySQLShowTablesStatement(this.getDatabaseType(), null == ctx.fromDatabase() ? null : (FromDatabaseSegment)this.visit((ParseTree)ctx.fromDatabase()), null == ctx.showFilter() ? null : (ShowFilterSegment)this.visit((ParseTree)ctx.showFilter()), null != ctx.FULL());
        result.addParameterMarkers(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitShowTriggers(MySQLStatementParser.ShowTriggersContext ctx) {
        MySQLShowTriggersStatement result = new MySQLShowTriggersStatement(this.getDatabaseType(), null == ctx.fromDatabase() ? null : (FromDatabaseSegment)this.visit((ParseTree)ctx.fromDatabase()), null == ctx.showFilter() ? null : (ShowFilterSegment)this.visit((ParseTree)ctx.showFilter()));
        result.addParameterMarkers(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitShowWhereClause(MySQLStatementParser.ShowWhereClauseContext ctx) {
        return new WhereSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (ExpressionSegment)this.visit((ParseTree)ctx.expr()));
    }

    @Override
    public ASTNode visitShowTableStatus(MySQLStatementParser.ShowTableStatusContext ctx) {
        MySQLShowTableStatusStatement result = new MySQLShowTableStatusStatement(this.getDatabaseType(), null == ctx.fromDatabase() ? null : (FromDatabaseSegment)this.visit((ParseTree)ctx.fromDatabase()), null == ctx.showFilter() ? null : (ShowFilterSegment)this.visit((ParseTree)ctx.showFilter()));
        result.addParameterMarkers(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitShowColumns(MySQLStatementParser.ShowColumnsContext ctx) {
        MySQLShowColumnsStatement result = new MySQLShowColumnsStatement(this.getDatabaseType(), null == ctx.fromTable() ? null : ((FromTableSegment)this.visit((ParseTree)ctx.fromTable())).getTable(), null == ctx.fromDatabase() ? null : (FromDatabaseSegment)this.visit((ParseTree)ctx.fromDatabase()), null == ctx.showFilter() ? null : (ShowFilterSegment)this.visit((ParseTree)ctx.showFilter()));
        result.addParameterMarkers(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitShowFilter(MySQLStatementParser.ShowFilterContext ctx) {
        ShowFilterSegment result = new ShowFilterSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
        if (null != ctx.showLike()) {
            result.setLike((ShowLikeSegment)this.visit((ParseTree)ctx.showLike()));
        }
        if (null != ctx.showWhereClause()) {
            result.setWhere((WhereSegment)this.visit((ParseTree)ctx.showWhereClause()));
        }
        return result;
    }

    @Override
    public ASTNode visitShowIndex(MySQLStatementParser.ShowIndexContext ctx) {
        return new MySQLShowIndexStatement(this.getDatabaseType(), null == ctx.fromTable() ? null : ((FromTableSegment)this.visitFromTable(ctx.fromTable())).getTable(), null == ctx.fromDatabase() ? null : (FromDatabaseSegment)this.visit((ParseTree)ctx.fromDatabase()));
    }

    @Override
    public ASTNode visitShowCreateTable(MySQLStatementParser.ShowCreateTableContext ctx) {
        return new MySQLShowCreateTableStatement(this.getDatabaseType(), (SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
    }

    @Override
    public ASTNode visitShowCreateTrigger(MySQLStatementParser.ShowCreateTriggerContext ctx) {
        return new MySQLShowCreateTriggerStatement(this.getDatabaseType(), ((IdentifierValue)this.visit((ParseTree)ctx.triggerName())).getValue());
    }

    @Override
    public ASTNode visitShowRelaylogEvent(MySQLStatementParser.ShowRelaylogEventContext ctx) {
        return new MySQLShowRelayLogEventsStatement(this.getDatabaseType(), null == ctx.logName() ? null : ((StringLiteralValue)this.visit((ParseTree)ctx.logName().stringLiterals())).getValue(), null == ctx.limitClause() ? null : (LimitSegment)this.visit((ParseTree)ctx.limitClause()), null == ctx.channelName() ? null : ((IdentifierValue)this.visit((ParseTree)ctx.channelName())).getValue());
    }

    @Override
    public ASTNode visitShowFunctionCode(MySQLStatementParser.ShowFunctionCodeContext ctx) {
        return new MySQLShowFunctionCodeStatement(this.getDatabaseType(), ((FunctionSegment)this.visit((ParseTree)ctx.functionName())).getFunctionName());
    }

    @Override
    public ASTNode visitShowGrants(MySQLStatementParser.ShowGrantsContext ctx) {
        return new MySQLShowGrantsStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitShowMasterStatus(MySQLStatementParser.ShowMasterStatusContext ctx) {
        return new MySQLShowMasterStatusStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitShowSlaveHosts(MySQLStatementParser.ShowSlaveHostsContext ctx) {
        return new MySQLShowSlaveHostsStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitShowReplicaStatus(MySQLStatementParser.ShowReplicaStatusContext ctx) {
        return new MySQLShowReplicaStatusStatement(this.getDatabaseType(), null == ctx.channelName() ? null : ((IdentifierValue)this.visit((ParseTree)ctx.channelName())).getValue());
    }

    @Override
    public ASTNode visitShowSlaveStatus(MySQLStatementParser.ShowSlaveStatusContext ctx) {
        return new MySQLShowSlaveStatusStatement(this.getDatabaseType(), null == ctx.channelName() ? null : ((IdentifierValue)this.visit((ParseTree)ctx.channelName())).getValue());
    }

    @Override
    public ASTNode visitCreateResourceGroup(MySQLStatementParser.CreateResourceGroupContext ctx) {
        return new MySQLCreateResourceGroupStatement(this.getDatabaseType(), ((IdentifierValue)this.visit((ParseTree)ctx.groupName())).getValue());
    }

    @Override
    public ASTNode visitBinlog(MySQLStatementParser.BinlogContext ctx) {
        return new MySQLBinlogStatement(this.getDatabaseType(), ((StringLiteralValue)this.visit((ParseTree)ctx.stringLiterals())).getValue());
    }

    @Override
    public ASTNode visitFromTable(MySQLStatementParser.FromTableContext ctx) {
        FromTableSegment result = new FromTableSegment();
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        return result;
    }

    @Override
    public ASTNode visitShowVariables(MySQLStatementParser.ShowVariablesContext ctx) {
        MySQLShowVariablesStatement result = new MySQLShowVariablesStatement(this.getDatabaseType(), null == ctx.showFilter() ? null : (ShowFilterSegment)this.visit((ParseTree)ctx.showFilter()));
        result.addParameterMarkers(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitShowCharacterSet(MySQLStatementParser.ShowCharacterSetContext ctx) {
        MySQLShowCharacterSetStatement result = new MySQLShowCharacterSetStatement(this.getDatabaseType(), null == ctx.showFilter() ? null : (ShowFilterSegment)this.visit((ParseTree)ctx.showFilter()));
        result.addParameterMarkers(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitShowCollation(MySQLStatementParser.ShowCollationContext ctx) {
        MySQLShowCollationStatement result = new MySQLShowCollationStatement(this.getDatabaseType(), null == ctx.showFilter() ? null : (ShowFilterSegment)this.visit((ParseTree)ctx.showFilter()));
        result.addParameterMarkers(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitShowFunctionStatus(MySQLStatementParser.ShowFunctionStatusContext ctx) {
        MySQLShowFunctionStatusStatement result = new MySQLShowFunctionStatusStatement(this.getDatabaseType(), null == ctx.showFilter() ? null : (ShowFilterSegment)this.visit((ParseTree)ctx.showFilter()));
        result.addParameterMarkers(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitShowProcedureStatus(MySQLStatementParser.ShowProcedureStatusContext ctx) {
        MySQLShowProcedureStatusStatement result = new MySQLShowProcedureStatusStatement(this.getDatabaseType(), null == ctx.showFilter() ? null : (ShowFilterSegment)this.visit((ParseTree)ctx.showFilter()));
        result.addParameterMarkers(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitShowOpenTables(MySQLStatementParser.ShowOpenTablesContext ctx) {
        MySQLShowOpenTablesStatement result = new MySQLShowOpenTablesStatement(this.getDatabaseType(), null == ctx.fromDatabase() ? null : (FromDatabaseSegment)this.visit((ParseTree)ctx.fromDatabase()), null == ctx.showFilter() ? null : (ShowFilterSegment)this.visit((ParseTree)ctx.showFilter()));
        result.addParameterMarkers(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitShowPlugins(MySQLStatementParser.ShowPluginsContext ctx) {
        return new MySQLShowPluginsStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitShowPrivileges(MySQLStatementParser.ShowPrivilegesContext ctx) {
        return new MySQLShowPrivilegesStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitShutdown(MySQLStatementParser.ShutdownContext ctx) {
        return new MySQLShutdownStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitShowProcesslist(MySQLStatementParser.ShowProcesslistContext ctx) {
        return new MySQLShowProcessListStatement(this.getDatabaseType(), null != ctx.FULL());
    }

    @Override
    public ASTNode visitShowCreateUser(MySQLStatementParser.ShowCreateUserContext ctx) {
        return new MySQLShowCreateUserStatement(this.getDatabaseType(), ((IdentifierValue)this.visit((ParseTree)ctx.username())).getValue());
    }

    @Override
    public ASTNode visitSetVariable(MySQLStatementParser.SetVariableContext ctx) {
        return new SetStatement(this.getDatabaseType(), this.getVariableAssigns(ctx.optionValueList()));
    }

    private List<VariableAssignSegment> getVariableAssigns(MySQLStatementParser.OptionValueListContext ctx) {
        LinkedList<VariableAssignSegment> result = new LinkedList<VariableAssignSegment>();
        result.add(null == ctx.optionValueNoOptionType() ? this.getVariableAssignSegment(ctx) : this.getVariableAssignSegment(ctx.optionValueNoOptionType()));
        for (MySQLStatementParser.OptionValueContext each : ctx.optionValue()) {
            result.add(this.getVariableAssignSegment(each));
        }
        return result;
    }

    private VariableAssignSegment getVariableAssignSegment(MySQLStatementParser.OptionValueContext ctx) {
        if (null != ctx.optionValueNoOptionType()) {
            return this.getVariableAssignSegment(ctx.optionValueNoOptionType());
        }
        VariableSegment variable = new VariableSegment(ctx.internalVariableName().start.getStartIndex(), ctx.internalVariableName().stop.getStopIndex(), ctx.internalVariableName().getText(), ctx.optionType().getText());
        return new VariableAssignSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), variable, ctx.setExprOrDefault().getText());
    }

    private VariableAssignSegment getVariableAssignSegment(MySQLStatementParser.OptionValueListContext ctx) {
        VariableSegment variable = new VariableSegment(ctx.internalVariableName().start.getStartIndex(), ctx.internalVariableName().stop.getStopIndex(), ctx.internalVariableName().getText(), ctx.optionType().getText());
        return new VariableAssignSegment(ctx.start.getStartIndex(), ctx.setExprOrDefault().stop.getStopIndex(), variable, ctx.setExprOrDefault().getText());
    }

    private VariableAssignSegment getVariableAssignSegment(MySQLStatementParser.OptionValueNoOptionTypeContext ctx) {
        return new VariableAssignSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), this.getVariableSegment(ctx), this.getAssignValue(ctx));
    }

    private VariableSegment getVariableSegment(MySQLStatementParser.OptionValueNoOptionTypeContext ctx) {
        if (null != ctx.NAMES()) {
            return new VariableSegment(ctx.NAMES().getSymbol().getStartIndex(), ctx.NAMES().getSymbol().getStopIndex(), "character_set_client");
        }
        if (null != ctx.internalVariableName()) {
            return new VariableSegment(ctx.internalVariableName().start.getStartIndex(), ctx.internalVariableName().stop.getStopIndex(), ctx.internalVariableName().getText());
        }
        if (null != ctx.userVariable()) {
            return new VariableSegment(ctx.userVariable().start.getStartIndex(), ctx.userVariable().stop.getStopIndex(), ctx.userVariable().getText());
        }
        if (null != ctx.setSystemVariable()) {
            VariableSegment result = new VariableSegment(ctx.setSystemVariable().start.getStartIndex(), ctx.setSystemVariable().stop.getStopIndex(), ctx.setSystemVariable().internalVariableName().getText());
            MySQLStatementParser.OptionTypeContext optionType = ctx.setSystemVariable().optionType();
            result.setScope(null == optionType ? "SESSION" : optionType.getText());
            return result;
        }
        return null;
    }

    private String getAssignValue(MySQLStatementParser.OptionValueNoOptionTypeContext ctx) {
        if (null != ctx.NAMES()) {
            return ctx.charsetName().getText();
        }
        if (null != ctx.internalVariableName()) {
            return ctx.setExprOrDefault().getText();
        }
        if (null != ctx.userVariable()) {
            return ctx.expr().getText();
        }
        if (null != ctx.setSystemVariable()) {
            return ctx.setExprOrDefault().getText();
        }
        return null;
    }

    @Override
    public ASTNode visitSetCharacter(MySQLStatementParser.SetCharacterContext ctx) {
        int startIndex = null == ctx.CHARSET() ? ctx.CHARACTER().getSymbol().getStartIndex() : ctx.CHARSET().getSymbol().getStartIndex();
        int stopIndex = null == ctx.CHARSET() ? ctx.SET(1).getSymbol().getStopIndex() : ctx.CHARSET().getSymbol().getStopIndex();
        String variableName = null == ctx.CHARSET() ? "character_set_client" : ctx.CHARSET().getText();
        VariableSegment variable = new VariableSegment(startIndex, stopIndex, variableName);
        String assignValue = null == ctx.DEFAULT() ? ctx.charsetName().getText() : ctx.DEFAULT().getText();
        return new SetStatement(this.getDatabaseType(), Collections.singletonList(new VariableAssignSegment(startIndex, stopIndex, variable, assignValue)));
    }

    @Override
    public ASTNode visitFromDatabase(MySQLStatementParser.FromDatabaseContext ctx) {
        return new FromDatabaseSegment(ctx.getStart().getStartIndex(), (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()));
    }

    @Override
    public ASTNode visitShowLike(MySQLStatementParser.ShowLikeContext ctx) {
        StringLiteralValue literalValue = (StringLiteralValue)this.visit((ParseTree)ctx.stringLiterals());
        return new ShowLikeSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), literalValue.getValue());
    }

    @Override
    public ASTNode visitCreateLoadableFunction(MySQLStatementParser.CreateLoadableFunctionContext ctx) {
        return new MySQLCreateLoadableFunctionStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitInstallComponent(MySQLStatementParser.InstallComponentContext ctx) {
        return new MySQLInstallComponentStatement(this.getDatabaseType(), ctx.componentName().stream().map(each -> ((StringLiteralValue)this.visit((ParseTree)each.string_())).getValue()).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitUninstallComponent(MySQLStatementParser.UninstallComponentContext ctx) {
        return new MySQLUninstallComponentStatement(this.getDatabaseType(), ctx.componentName().stream().map(each -> ((StringLiteralValue)this.visit((ParseTree)each.string_())).getValue()).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitRestart(MySQLStatementParser.RestartContext ctx) {
        return new MySQLRestartStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitSetResourceGroup(MySQLStatementParser.SetResourceGroupContext ctx) {
        return new MySQLSetResourceGroupStatement(this.getDatabaseType(), ((IdentifierValue)this.visit((ParseTree)ctx.groupName())).getValue());
    }

    @Override
    public ASTNode visitCheckTable(MySQLStatementParser.CheckTableContext ctx) {
        return new MySQLCheckTableStatement(this.getDatabaseType(), ((CollectionValue)this.visit((ParseTree)ctx.tableList())).getValue());
    }

    @Override
    public ASTNode visitDropResourceGroup(MySQLStatementParser.DropResourceGroupContext ctx) {
        return new MySQLDropResourceGroupStatement(this.getDatabaseType(), ((IdentifierValue)this.visit((ParseTree)ctx.groupName())).getValue());
    }

    @Override
    public ASTNode visitAlterResourceGroup(MySQLStatementParser.AlterResourceGroupContext ctx) {
        return new MySQLAlterResourceGroupStatement(this.getDatabaseType(), ((IdentifierValue)this.visit((ParseTree)ctx.groupName())).getValue());
    }

    @Override
    public ASTNode visitChangeMasterTo(MySQLStatementParser.ChangeMasterToContext ctx) {
        return new MySQLChangeMasterStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitStartSlave(MySQLStatementParser.StartSlaveContext ctx) {
        return new MySQLStartSlaveStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitStopSlave(MySQLStatementParser.StopSlaveContext ctx) {
        return new MySQLStopSlaveStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitChangeReplicationSourceTo(MySQLStatementParser.ChangeReplicationSourceToContext ctx) {
        return new MySQLChangeReplicationSourceToStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitStartReplica(MySQLStatementParser.StartReplicaContext ctx) {
        return new MySQLStartReplicaStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDelimiter(MySQLStatementParser.DelimiterContext ctx) {
        return new MySQLDelimiterStatement(this.getDatabaseType(), ctx.delimiterName().getText());
    }

    @Override
    public ASTNode visitHelp(MySQLStatementParser.HelpContext ctx) {
        return new MySQLHelpStatement(this.getDatabaseType(), ctx.textOrIdentifier().getText());
    }
}

