/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.postgresql.handler.admin.executor;

import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminUpdateExecutor;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.variable.charset.CharsetSetExecutor;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.variable.session.SessionVariableRecordExecutor;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dal.VariableAssignSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dal.SetStatement;

public final class PostgreSQLSetVariableAdminExecutor
implements DatabaseAdminUpdateExecutor {
    private final DatabaseType databaseType = (DatabaseType)TypedSPILoader.getService(DatabaseType.class, (Object)"PostgreSQL");
    private final SetStatement setStatement;

    public void execute(ConnectionSession connectionSession, ShardingSphereMetaData metaData) {
        VariableAssignSegment variableAssignSegment = (VariableAssignSegment)this.setStatement.getVariableAssigns().iterator().next();
        String variableName = variableAssignSegment.getVariable().getVariable().toLowerCase();
        String assignValue = variableAssignSegment.getAssignValue();
        new CharsetSetExecutor(this.databaseType, connectionSession).set(variableName, assignValue);
        new SessionVariableRecordExecutor(this.databaseType, connectionSession).recordVariable(variableName, assignValue);
    }

    @Generated
    public PostgreSQLSetVariableAdminExecutor(SetStatement setStatement) {
        this.setStatement = setStatement;
    }
}

