/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.mysql.packet.binlog.row.column.value.string;

import io.netty.buffer.ByteBuf;
import java.io.Serializable;
import java.math.BigInteger;
import lombok.Generated;
import org.apache.shardingsphere.infra.exception.generic.UnsupportedSQLOperationException;

public final class MySQLJsonValueDecoder {
    private static final BigInteger MAX_BIG_INTEGER_VALUE = new BigInteger("18446744073709551615");

    public static Serializable decode(ByteBuf byteBuf) {
        int valueType = byteBuf.readUnsignedByte() & 0xFF;
        StringBuilder result = new StringBuilder();
        MySQLJsonValueDecoder.decodeValue(valueType, 1, byteBuf, result);
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void decodeValue(int type, int offset, ByteBuf byteBuf, StringBuilder stringBuilder) {
        int oldOffset = byteBuf.readerIndex();
        byteBuf.readerIndex(offset);
        try {
            switch (type) {
                case 0: {
                    MySQLJsonValueDecoder.decodeJsonObject(true, byteBuf.slice(), stringBuilder);
                    return;
                }
                case 1: {
                    MySQLJsonValueDecoder.decodeJsonObject(false, byteBuf.slice(), stringBuilder);
                    return;
                }
                case 2: {
                    MySQLJsonValueDecoder.decodeJsonArray(true, byteBuf.slice(), stringBuilder);
                    return;
                }
                case 3: {
                    MySQLJsonValueDecoder.decodeJsonArray(false, byteBuf.slice(), stringBuilder);
                    return;
                }
                case 5: {
                    stringBuilder.append(byteBuf.readShortLE());
                    return;
                }
                case 6: {
                    stringBuilder.append(byteBuf.readUnsignedShortLE());
                    return;
                }
                case 7: {
                    stringBuilder.append(byteBuf.readIntLE());
                    return;
                }
                case 8: {
                    stringBuilder.append(byteBuf.readUnsignedIntLE());
                    return;
                }
                case 9: {
                    stringBuilder.append(byteBuf.readLongLE());
                    return;
                }
                case 10: {
                    stringBuilder.append(MySQLJsonValueDecoder.readUnsignedLongLE(byteBuf));
                    return;
                }
                case 11: {
                    stringBuilder.append(byteBuf.readDoubleLE());
                    return;
                }
                case 12: {
                    MySQLJsonValueDecoder.outputString(MySQLJsonValueDecoder.decodeString(byteBuf.slice()), stringBuilder);
                    return;
                }
                default: {
                    throw new UnsupportedSQLOperationException(String.valueOf(type));
                }
            }
        }
        finally {
            byteBuf.readerIndex(oldOffset);
        }
    }

    private static BigInteger readUnsignedLongLE(ByteBuf byteBuf) {
        long value = byteBuf.readLongLE();
        return 0L <= value ? BigInteger.valueOf(value) : MAX_BIG_INTEGER_VALUE.add(BigInteger.valueOf(1L + value));
    }

    private static void decodeJsonObject(boolean isSmall, ByteBuf byteBuf, StringBuilder stringBuilder) {
        int i;
        stringBuilder.append('{');
        int count = MySQLJsonValueDecoder.getIntBasedObjectSize(byteBuf, isSmall);
        MySQLJsonValueDecoder.getIntBasedObjectSize(byteBuf, isSmall);
        String[] keys = new String[count];
        for (i = 0; i < count; ++i) {
            keys[i] = MySQLJsonValueDecoder.decodeKeyEntry(isSmall, byteBuf);
        }
        for (i = 0; i < count; ++i) {
            if (0 < i) {
                stringBuilder.append(',');
            }
            stringBuilder.append('\"').append(keys[i]).append("\":");
            MySQLJsonValueDecoder.decodeValueEntry(isSmall, byteBuf, stringBuilder);
        }
        stringBuilder.append('}');
    }

    private static void decodeJsonArray(boolean isSmall, ByteBuf byteBuf, StringBuilder stringBuilder) {
        stringBuilder.append('[');
        int count = MySQLJsonValueDecoder.getIntBasedObjectSize(byteBuf, isSmall);
        MySQLJsonValueDecoder.getIntBasedObjectSize(byteBuf, isSmall);
        for (int i = 0; i < count; ++i) {
            if (0 < i) {
                stringBuilder.append(',');
            }
            MySQLJsonValueDecoder.decodeValueEntry(isSmall, byteBuf, stringBuilder);
        }
        stringBuilder.append(']');
    }

    private static String decodeKeyEntry(boolean isSmall, ByteBuf byteBuf) {
        int offset = MySQLJsonValueDecoder.getIntBasedObjectSize(byteBuf, isSmall);
        int length = byteBuf.readUnsignedShortLE();
        byte[] data = new byte[length];
        byteBuf.getBytes(offset, data, 0, length);
        return new String(data);
    }

    private static void decodeValueEntry(boolean isSmall, ByteBuf byteBuf, StringBuilder stringBuilder) {
        int type = byteBuf.readUnsignedByte() & 0xFF;
        switch (type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                MySQLJsonValueDecoder.decodeValue(type, MySQLJsonValueDecoder.getIntBasedObjectSize(byteBuf, isSmall), byteBuf, stringBuilder);
                break;
            }
            case 5: {
                stringBuilder.append(byteBuf.readShortLE());
                if (isSmall) break;
                byteBuf.skipBytes(2);
                break;
            }
            case 6: {
                stringBuilder.append(MySQLJsonValueDecoder.getIntBasedObjectSize(byteBuf, isSmall));
                break;
            }
            case 7: {
                if (isSmall) {
                    MySQLJsonValueDecoder.decodeValue(type, byteBuf.readUnsignedShortLE(), byteBuf, stringBuilder);
                    break;
                }
                stringBuilder.append(byteBuf.readIntLE());
                break;
            }
            case 8: {
                if (isSmall) {
                    MySQLJsonValueDecoder.decodeValue(type, byteBuf.readUnsignedShortLE(), byteBuf, stringBuilder);
                    break;
                }
                stringBuilder.append(byteBuf.readUnsignedIntLE());
                break;
            }
            case 4: {
                MySQLJsonValueDecoder.outputLiteral(MySQLJsonValueDecoder.getIntBasedObjectSize(byteBuf, isSmall), stringBuilder);
                break;
            }
            default: {
                throw new UnsupportedSQLOperationException(String.valueOf(type));
            }
        }
    }

    private static int getIntBasedObjectSize(ByteBuf byteBuf, boolean isSmall) {
        return isSmall ? byteBuf.readUnsignedShortLE() : (int)byteBuf.readUnsignedIntLE();
    }

    private static void outputLiteral(int inlineValue, StringBuilder out) {
        switch (inlineValue) {
            case 0: {
                out.append("null");
                break;
            }
            case 1: {
                out.append("true");
                break;
            }
            case 2: {
                out.append("false");
                break;
            }
            default: {
                throw new UnsupportedSQLOperationException(String.valueOf(inlineValue));
            }
        }
    }

    private static String decodeString(ByteBuf byteBuf) {
        int length = MySQLJsonValueDecoder.decodeDataLength(byteBuf);
        byte[] buffer = new byte[length];
        byteBuf.readBytes(buffer, 0, length);
        return new String(buffer);
    }

    private static int decodeDataLength(ByteBuf byteBuf) {
        int result = 0;
        int i = 0;
        while (true) {
            short data = byteBuf.readUnsignedByte();
            result |= (data & 0x7F) << 7 * i;
            if (0 == (data & 0x80)) break;
            ++i;
        }
        return result;
    }

    private static void outputString(String str, StringBuilder out) {
        out.append('\"');
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\"' || c == '\\') {
                out.append('\\');
            }
            out.append(c);
        }
        out.append('\"');
    }

    @Generated
    private MySQLJsonValueDecoder() {
    }

    public static final class JsonValueTypes {
        public static final byte SMALL_JSON_OBJECT = 0;
        public static final byte LARGE_JSON_OBJECT = 1;
        public static final byte SMALL_JSON_ARRAY = 2;
        public static final byte LARGE_JSON_ARRAY = 3;
        public static final byte LITERAL = 4;
        public static final byte LITERAL_NULL = 0;
        public static final byte LITERAL_TRUE = 1;
        public static final byte LITERAL_FALSE = 2;
        public static final byte INT16 = 5;
        public static final byte UINT16 = 6;
        public static final byte INT32 = 7;
        public static final byte UINT32 = 8;
        public static final byte INT64 = 9;
        public static final byte UINT64 = 10;
        public static final byte DOUBLE = 11;
        public static final byte STRING = 12;
        public static final byte CUSTOM_DATA = 15;

        @Generated
        private JsonValueTypes() {
        }
    }
}

