/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.mysql.packet.binlog.row.column.value.time;

import java.io.Serializable;
import java.time.LocalTime;
import org.apache.shardingsphere.database.protocol.mysql.packet.binlog.row.column.MySQLBinlogColumnDef;
import org.apache.shardingsphere.database.protocol.mysql.packet.binlog.row.column.value.MySQLBinlogProtocolValue;
import org.apache.shardingsphere.database.protocol.mysql.packet.binlog.row.column.value.time.MySQLFractionalSeconds;
import org.apache.shardingsphere.database.protocol.mysql.payload.MySQLPacketPayload;

public final class MySQLTime2BinlogProtocolValue
implements MySQLBinlogProtocolValue {
    @Override
    public Serializable read(MySQLBinlogColumnDef columnDef, MySQLPacketPayload payload) {
        int time = payload.getByteBuf().readUnsignedMedium();
        if (0x800000 == time) {
            return "00:00:00";
        }
        MySQLFractionalSeconds fractionalSeconds = new MySQLFractionalSeconds(columnDef.getColumnMeta(), payload);
        int hour = (time >> 12) % 1024;
        int minute = (time >> 6) % 64;
        int second = time % 64;
        return LocalTime.of(hour, minute, second).withNano(fractionalSeconds.getNanos());
    }
}

