/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.mysql.packet.command.binlog;

import lombok.Generated;
import org.apache.shardingsphere.database.protocol.mysql.packet.command.MySQLCommandPacket;
import org.apache.shardingsphere.database.protocol.mysql.packet.command.MySQLCommandPacketType;
import org.apache.shardingsphere.database.protocol.mysql.payload.MySQLPacketPayload;

public final class MySQLComRegisterSlaveCommandPacket
extends MySQLCommandPacket {
    private final int serverId;
    private final String slaveHostname;
    private final String slaveUser;
    private final String slavePassword;
    private final int slavePort;
    private final int masterId;

    public MySQLComRegisterSlaveCommandPacket(int serverId, String slaveHostname, String slaveUser, String slavePassword, int slavePort) {
        super(MySQLCommandPacketType.COM_REGISTER_SLAVE);
        this.serverId = serverId;
        this.slaveHostname = slaveHostname;
        this.slaveUser = slaveUser;
        this.slavePassword = slavePassword;
        this.slavePort = slavePort;
        this.masterId = 0;
    }

    public MySQLComRegisterSlaveCommandPacket(MySQLPacketPayload payload) {
        super(MySQLCommandPacketType.COM_REGISTER_SLAVE);
        this.serverId = payload.readInt4();
        this.slaveHostname = payload.readStringFix(payload.readInt1());
        this.slaveUser = payload.readStringFix(payload.readInt1());
        this.slavePassword = payload.readStringFix(payload.readInt1());
        this.slavePort = payload.readInt2();
        payload.skipReserved(4);
        this.masterId = payload.readInt4();
    }

    @Override
    protected void doWrite(MySQLPacketPayload payload) {
        payload.writeInt4(this.serverId);
        payload.writeInt1(this.slaveHostname.getBytes().length);
        payload.writeStringFix(this.slaveHostname);
        payload.writeInt1(this.slaveUser.getBytes().length);
        payload.writeStringFix(this.slaveUser);
        payload.writeInt1(this.slavePassword.getBytes().length);
        payload.writeStringFix(this.slavePassword);
        payload.writeInt2(this.slavePort);
        payload.writeBytes(new byte[4]);
        payload.writeInt4(this.masterId);
    }

    @Generated
    public int getServerId() {
        return this.serverId;
    }

    @Generated
    public String getSlaveHostname() {
        return this.slaveHostname;
    }

    @Generated
    public String getSlaveUser() {
        return this.slaveUser;
    }

    @Generated
    public String getSlavePassword() {
        return this.slavePassword;
    }

    @Generated
    public int getSlavePort() {
        return this.slavePort;
    }

    @Generated
    public int getMasterId() {
        return this.masterId;
    }
}

