/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.mysql.packet.command.query.binary.execute.protocol;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import org.apache.shardingsphere.database.protocol.mysql.packet.command.query.binary.execute.protocol.MySQLBinaryProtocolValue;
import org.apache.shardingsphere.database.protocol.mysql.payload.MySQLPacketPayload;

public final class MySQLTimeBinaryProtocolValue
implements MySQLBinaryProtocolValue {
    @Override
    public Object read(MySQLPacketPayload payload, boolean unsigned) throws SQLException {
        int length = payload.readInt1();
        payload.readInt1();
        payload.readInt4();
        switch (length) {
            case 0: {
                return new Timestamp(0L);
            }
            case 8: {
                return this.getTimestamp(payload);
            }
            case 12: {
                Timestamp result = this.getTimestamp(payload);
                result.setNanos(payload.readInt4());
                return result;
            }
        }
        throw new SQLFeatureNotSupportedException(String.format("Wrong length `%d` of MYSQL_TYPE_DATE", length));
    }

    private Timestamp getTimestamp(MySQLPacketPayload payload) {
        Timestamp result = Timestamp.valueOf(LocalDateTime.of(0, 1, 1, payload.readInt1(), payload.readInt1(), payload.readInt1()));
        result.setNanos(0);
        return result;
    }

    @Override
    public void write(MySQLPacketPayload payload, Object value) {
        boolean isNanosAbsent;
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(((Time)value).getTime()), ZoneId.systemDefault());
        int hours = localDateTime.getHour();
        int minutes = localDateTime.getMinute();
        int seconds = localDateTime.getSecond();
        int nanos = localDateTime.getNano();
        boolean isTimeAbsent = 0 == hours && 0 == minutes && 0 == seconds;
        boolean bl = isNanosAbsent = 0 == nanos;
        if (isTimeAbsent && isNanosAbsent) {
            payload.writeInt1(0);
            return;
        }
        if (isNanosAbsent) {
            payload.writeInt1(8);
            this.writeTime(payload, hours, minutes, seconds);
            return;
        }
        payload.writeInt1(12);
        this.writeTime(payload, hours, minutes, seconds);
        this.writeNanos(payload, nanos);
    }

    private void writeTime(MySQLPacketPayload payload, int hourOfDay, int minutes, int seconds) {
        payload.writeInt1(0);
        payload.writeInt4(0);
        payload.writeInt1(hourOfDay);
        payload.writeInt1(minutes);
        payload.writeInt1(seconds);
    }

    private void writeNanos(MySQLPacketPayload payload, int nanos) {
        payload.writeInt4(nanos / 1000);
    }
}

