/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.firebird.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import org.apache.shardingsphere.database.protocol.codec.DatabasePacketCodecEngine;
import org.apache.shardingsphere.database.protocol.constant.CommonConstants;
import org.apache.shardingsphere.database.protocol.firebird.constant.FirebirdConstant;
import org.apache.shardingsphere.database.protocol.firebird.constant.protocol.FirebirdProtocolVersion;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.FirebirdCommandPacketFactory;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.FirebirdCommandPacketType;
import org.apache.shardingsphere.database.protocol.firebird.payload.FirebirdPacketPayload;
import org.apache.shardingsphere.database.protocol.packet.DatabasePacket;
import org.apache.shardingsphere.database.protocol.payload.PacketPayload;

public final class FirebirdPacketCodecEngine
implements DatabasePacketCodecEngine {
    private static final int MESSAGE_TYPE_LENGTH = 4;
    private static final int ALLOCATE_STATEMENT_REQUEST_PAYLOAD_LENGTH = 8;
    private static final int FREE_STATEMENT_REQUEST_PAYLOAD_LENGTH = 12;
    private final List<ByteBuf> pendingMessages = new LinkedList<ByteBuf>();
    private FirebirdCommandPacketType pendingPacketType;

    public boolean isValidHeader(int readableBytes) {
        return readableBytes >= 4;
    }

    public void decode(ChannelHandlerContext context, ByteBuf in, List<Object> out) {
        if (this.pendingMessages.isEmpty()) {
            int type = in.getInt(in.readerIndex());
            this.pendingPacketType = FirebirdCommandPacketType.valueOf(type);
            if (this.pendingPacketType == FirebirdCommandPacketType.ALLOCATE_STATEMENT) {
                this.handleMultiPacket(context, in, out, 8);
                return;
            }
            if (this.pendingPacketType == FirebirdCommandPacketType.FREE_STATEMENT) {
                this.handleMultiPacket(context, in, out, 12);
                return;
            }
        }
        this.addToBuffer(context, in, out);
    }

    private void handleMultiPacket(ChannelHandlerContext context, ByteBuf in, List<Object> out, int firstPacketLength) {
        out.add(in.readRetainedSlice(firstPacketLength));
        if (in.readableBytes() > 4) {
            this.decode(context, in, out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToBuffer(ChannelHandlerContext context, ByteBuf in, List<Object> out) {
        ByteBuf buffer = this.mergePendingMessages(context, in);
        boolean shouldRelease = buffer != in;
        try {
            this.processPackets(context, buffer, out);
        }
        finally {
            if (shouldRelease) {
                buffer.release();
            }
        }
    }

    private ByteBuf mergePendingMessages(ChannelHandlerContext context, ByteBuf in) {
        if (this.pendingMessages.isEmpty()) {
            return in;
        }
        CompositeByteBuf result = context.alloc().compositeBuffer(this.pendingMessages.size() + 1);
        result.addComponents(true, this.pendingMessages);
        this.pendingMessages.clear();
        result.addComponent(true, in.readRetainedSlice(in.readableBytes()));
        return result;
    }

    private void processPackets(ChannelHandlerContext context, ByteBuf buffer, List<Object> out) {
        Charset charset = (Charset)context.channel().attr(CommonConstants.CHARSET_ATTRIBUTE_KEY).get();
        while (buffer.isReadable()) {
            if (!this.isValidHeader(buffer.readableBytes())) {
                this.pendingMessages.add(buffer.readRetainedSlice(buffer.readableBytes()));
                return;
            }
            int readerIndex = buffer.readerIndex();
            FirebirdCommandPacketType commandType = FirebirdCommandPacketType.valueOf(buffer.getInt(readerIndex));
            if (FirebirdCommandPacketType.VOID == commandType) {
                buffer.skipBytes(4);
                continue;
            }
            int packetLength = this.findPacketLength(context, buffer, commandType, charset);
            if (packetLength < 0) {
                this.pendingPacketType = commandType;
                this.pendingMessages.add(buffer.readRetainedSlice(buffer.readableBytes()));
                return;
            }
            this.pendingPacketType = null;
            out.add(buffer.readRetainedSlice(packetLength));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int findPacketLength(ChannelHandlerContext context, ByteBuf buffer, FirebirdCommandPacketType commandType, Charset charset) {
        int readerIndex = buffer.readerIndex();
        int readableBytes = buffer.readableBytes();
        ByteBuf slice = buffer.retainedSlice(readerIndex, readableBytes);
        try {
            FirebirdPacketPayload payload = new FirebirdPacketPayload(slice, charset);
            int expectedLength = FirebirdCommandPacketFactory.getExpectedLength(commandType, payload, (FirebirdProtocolVersion)((Object)context.channel().attr(FirebirdConstant.CONNECTION_PROTOCOL_VERSION).get()));
            if (expectedLength <= 0) {
                int n = readableBytes;
                return n;
            }
            int n = readableBytes >= expectedLength ? expectedLength : -1;
            return n;
        }
        catch (IndexOutOfBoundsException ex) {
            int n = -1;
            return n;
        }
        finally {
            slice.release();
        }
    }

    public void encode(ChannelHandlerContext context, DatabasePacket message, ByteBuf out) {
        FirebirdPacketPayload payload = new FirebirdPacketPayload(out, (Charset)context.channel().attr(CommonConstants.CHARSET_ATTRIBUTE_KEY).get());
        try {
            message.write((PacketPayload)payload);
        }
        catch (RuntimeException ex) {
            payload.getByteBuf().resetWriterIndex();
        }
    }

    public FirebirdPacketPayload createPacketPayload(ByteBuf message, Charset charset) {
        return new FirebirdPacketPayload(message, charset);
    }
}

