/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.firebird.packet.command.query.blob;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.FirebirdCommandPacket;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.FirebirdCommandPacketType;
import org.apache.shardingsphere.database.protocol.firebird.payload.FirebirdPacketPayload;

public final class FirebirdOpenBlobCommandPacket
extends FirebirdCommandPacket {
    private final byte[] blobParameterBuffer;
    private final int transactionId;
    private final long blobId;

    public FirebirdOpenBlobCommandPacket(FirebirdCommandPacketType commandType, FirebirdPacketPayload payload) {
        Preconditions.checkArgument((FirebirdCommandPacketType.OPEN_BLOB == commandType || FirebirdCommandPacketType.OPEN_BLOB2 == commandType ? 1 : 0) != 0, (String)"Unsupported blob command type: %s", (Object)((Object)commandType));
        payload.skipReserved(4);
        if (FirebirdCommandPacketType.OPEN_BLOB2 == commandType) {
            ByteBuf buffer = payload.readBuffer();
            this.blobParameterBuffer = new byte[buffer.readableBytes()];
            buffer.readBytes(this.blobParameterBuffer);
        } else {
            this.blobParameterBuffer = new byte[0];
        }
        this.transactionId = payload.readInt4();
        this.blobId = payload.readInt8();
    }

    @Override
    protected void write(FirebirdPacketPayload payload) {
    }

    public static int getLength(FirebirdCommandPacketType commandType, FirebirdPacketPayload payload) {
        Preconditions.checkArgument((FirebirdCommandPacketType.OPEN_BLOB == commandType || FirebirdCommandPacketType.OPEN_BLOB2 == commandType ? 1 : 0) != 0, (String)"Unsupported blob command type: %s", (Object)((Object)commandType));
        int length = 4;
        if (FirebirdCommandPacketType.OPEN_BLOB2 == commandType) {
            length += payload.getBufferLength(length);
        }
        length += 4;
        return length += 8;
    }

    @Generated
    public byte[] getBlobParameterBuffer() {
        return this.blobParameterBuffer;
    }

    @Generated
    public int getTransactionId() {
        return this.transactionId;
    }

    @Generated
    public long getBlobId() {
        return this.blobId;
    }
}

