/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.microprofile.client.sse;

import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.Providers;
import jakarta.ws.rs.sse.InboundSseEvent;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.concurrent.ExecutorService;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.impl.ProvidersImpl;
import org.apache.cxf.jaxrs.impl.tl.ThreadLocalProviders;
import org.apache.cxf.microprofile.client.Utils;
import org.apache.cxf.microprofile.client.sse.SsePublisher;
import org.apache.cxf.microprofile.client.sse.SseTypeSafeProcessor;
import org.reactivestreams.Publisher;

@Produces(value={"text/event-stream"})
public class SseMessageBodyReader
implements MessageBodyReader<Publisher<?>> {
    @Context
    Providers providers;
    @Context
    private MessageContext mc;

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Publisher.class.isAssignableFrom(type) && MediaType.SERVER_SENT_EVENTS_TYPE.isCompatible(mediaType);
    }

    public Publisher<?> readFrom(Class<Publisher<?>> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        ProvidersImpl providersImpl = (ProvidersImpl)(this.providers instanceof ThreadLocalProviders ? (Providers)((ThreadLocalProviders)this.providers).get() : this.providers);
        ExecutorService executor = Utils.getExecutorService(this.mc);
        SsePublisher publisher = new SsePublisher(entityStream, executor, (Providers)providersImpl);
        if (genericType instanceof ParameterizedType) {
            Type typeArgument = ((ParameterizedType)genericType).getActualTypeArguments()[0];
            if (typeArgument.equals(InboundSseEvent.class)) {
                return publisher;
            }
            return new SseTypeSafeProcessor(new GenericType(typeArgument), publisher);
        }
        return null;
    }
}

