/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html.base;

import jakarta.faces.application.ProjectStage;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIGraphic;
import jakarta.faces.component.behavior.ClientBehaviorHolder;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.core.api.shared.ComponentUtils;
import org.apache.myfaces.renderkit.RendererUtils;
import org.apache.myfaces.renderkit.html.base.HtmlRenderer;
import org.apache.myfaces.renderkit.html.util.ClientBehaviorRendererUtils;
import org.apache.myfaces.renderkit.html.util.CommonHtmlAttributesUtil;
import org.apache.myfaces.renderkit.html.util.CommonHtmlEventsUtil;
import org.apache.myfaces.renderkit.html.util.HTML;
import org.apache.myfaces.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.renderkit.html.util.ResourceUtils;

public class HtmlImageRendererBase
extends HtmlRenderer {
    private static final Logger log = Logger.getLogger(HtmlImageRendererBase.class.getName());

    public void decode(FacesContext context, UIComponent component) {
        super.decode(context, component);
        ClientBehaviorRendererUtils.decodeClientBehaviors(context, component);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        Level level;
        RendererUtils.checkParamValidity(facesContext, uiComponent, UIGraphic.class);
        ResponseWriter writer = facesContext.getResponseWriter();
        Map behaviors = null;
        if (uiComponent instanceof ClientBehaviorHolder && !(behaviors = ((ClientBehaviorHolder)uiComponent).getClientBehaviors()).isEmpty()) {
            ResourceUtils.renderDefaultJsfJsInlineIfNecessary(facesContext, writer);
        }
        writer.startElement("img", uiComponent);
        if (uiComponent instanceof ClientBehaviorHolder && !behaviors.isEmpty()) {
            HtmlRendererUtils.writeIdAndName(writer, uiComponent, facesContext);
        } else {
            HtmlRendererUtils.writeIdIfNecessary(writer, uiComponent, facesContext);
        }
        String url = RendererUtils.getIconSrc(facesContext, uiComponent, "url");
        if (url != null) {
            writer.writeURIAttribute("src", (Object)url, "value");
        } else {
            Level level2 = level = facesContext.isProjectStage(ProjectStage.Production) ? Level.FINE : Level.WARNING;
            if (log.isLoggable(level)) {
                log.log(level, "Component UIGraphic " + uiComponent.getClientId(facesContext) + " has no attribute url, value, name or attribute resolves to null. Path to component " + ComponentUtils.getPathToComponent((UIComponent)uiComponent));
            }
        }
        if (uiComponent.getAttributes().get("alt") == null) {
            Level level3 = level = facesContext.isProjectStage(ProjectStage.Production) ? Level.FINE : Level.WARNING;
            if (log.isLoggable(level)) {
                log.log(level, "Component UIGraphic " + uiComponent.getClientId(facesContext) + " has no attribute alt or attribute resolves to null. Path to component " + ComponentUtils.getPathToComponent((UIComponent)uiComponent));
            }
        }
        if (uiComponent instanceof ClientBehaviorHolder) {
            if (behaviors.isEmpty() && this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                CommonHtmlAttributesUtil.renderEventProperties(writer, CommonHtmlAttributesUtil.getMarkedAttributes(uiComponent), uiComponent);
            } else if (this.isCommonEventsOptimizationEnabled(facesContext)) {
                CommonHtmlEventsUtil.renderBehaviorizedEventHandlers(facesContext, writer, CommonHtmlAttributesUtil.getMarkedAttributes(uiComponent), CommonHtmlEventsUtil.getMarkedEvents(uiComponent), uiComponent, behaviors);
            } else {
                HtmlRendererUtils.renderBehaviorizedEventHandlers(facesContext, writer, uiComponent, behaviors);
            }
            if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.IMG_ATTRIBUTES);
                CommonHtmlAttributesUtil.renderCommonPassthroughPropertiesWithoutEvents(writer, CommonHtmlAttributesUtil.getMarkedAttributes(uiComponent), uiComponent);
            } else {
                HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.IMG_PASSTHROUGH_ATTRIBUTES_WITHOUT_EVENTS);
            }
        } else if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
            HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.IMG_ATTRIBUTES);
            CommonHtmlAttributesUtil.renderCommonPassthroughProperties(writer, CommonHtmlAttributesUtil.getMarkedAttributes(uiComponent), uiComponent);
        } else {
            HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.IMG_PASSTHROUGH_ATTRIBUTES);
        }
        writer.endElement("img");
    }
}

