/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings.converters;

import java.security.AccessController;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.descriptors.ClassNameConversionRequired;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.serializers.JavaSerializer;
import org.eclipse.persistence.sessions.serializers.Serializer;

public class SerializedObjectConverter
implements Converter,
ClassNameConversionRequired {
    protected DatabaseMapping mapping;
    protected Serializer serializer;
    protected String serializerClassName;
    protected String serializerPackage;

    public SerializedObjectConverter() {
        this.serializer = new JavaSerializer();
    }

    public SerializedObjectConverter(DatabaseMapping mapping) {
        this.mapping = mapping;
        this.serializer = new JavaSerializer();
    }

    public SerializedObjectConverter(DatabaseMapping mapping, Serializer serializer) {
        this.mapping = mapping;
        this.serializer = serializer;
    }

    public SerializedObjectConverter(DatabaseMapping mapping, String serializerClassName) {
        this.mapping = mapping;
        this.serializerClassName = serializerClassName;
    }

    @Override
    public void convertClassNamesToClasses(ClassLoader classLoader) {
        try {
            if (this.serializerClassName != null) {
                Class serializerClass = null;
                serializerClass = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.serializerClassName, true, classLoader)) : PrivilegedAccessHelper.getClassForName(this.serializerClassName, true, classLoader);
                this.serializer = (Serializer)serializerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (Exception exception) {
            throw ValidationException.classNotFoundWhileConvertingClassNames(this.serializerClassName, exception);
        }
    }

    @Override
    public Object convertDataValueToObjectValue(Object fieldValue, Session session) throws DescriptorException {
        if (fieldValue == null) {
            return null;
        }
        Object data = fieldValue;
        if (this.serializer.getType() == ClassConstants.APBYTE) {
            byte[] bytes;
            try {
                bytes = (byte[])session.getDatasourcePlatform().convertObject(fieldValue, ClassConstants.APBYTE);
            }
            catch (ConversionException exception) {
                throw ConversionException.couldNotBeConverted((Object)this.mapping, this.mapping.getDescriptor(), exception);
            }
            if (bytes == null || bytes.length == 0) {
                return null;
            }
            data = bytes;
        } else if (this.serializer.getType() == ClassConstants.STRING) {
            String text;
            try {
                text = (String)session.getDatasourcePlatform().convertObject(fieldValue, ClassConstants.STRING);
            }
            catch (ConversionException exception) {
                throw ConversionException.couldNotBeConverted((Object)this.mapping, this.mapping.getDescriptor(), exception);
            }
            if (text == null || text.length() == 0) {
                return null;
            }
            data = text;
        }
        try {
            return this.serializer.deserialize(data, session);
        }
        catch (Exception exception) {
            throw DescriptorException.notDeserializable(this.getMapping(), exception);
        }
    }

    @Override
    public Object convertObjectValueToDataValue(Object attributeValue, Session session) {
        if (attributeValue == null) {
            return null;
        }
        try {
            return this.serializer.serialize(attributeValue, session);
        }
        catch (Exception exception) {
            throw DescriptorException.notSerializable(this.getMapping(), exception);
        }
    }

    @Override
    public void initialize(DatabaseMapping mapping, Session session) {
        AbstractDirectMapping directMapping;
        this.mapping = mapping;
        if (this.getMapping().isDirectToFieldMapping() && (directMapping = (AbstractDirectMapping)this.getMapping()).getFieldClassification() == null) {
            directMapping.setFieldClassification(this.getSerializer().getType());
        }
        if (this.serializer != null) {
            this.serializer.initialize(mapping.getAttributeClassification(), this.serializerPackage, session);
        }
    }

    protected DatabaseMapping getMapping() {
        return this.mapping;
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    public Serializer getSerializer() {
        return this.serializer;
    }

    public void setSerializer(Serializer serializer) {
        this.serializer = serializer;
    }

    public String getSerializerClassName() {
        return this.serializerClassName;
    }

    public void setSerializerClassName(String serializerClassName) {
        this.serializerClassName = serializerClassName;
    }

    public String getSerializerPackage() {
        return this.serializerPackage;
    }

    public void setSerializerPackage(String serializerPackage) {
        this.serializerPackage = serializerPackage;
    }
}

