/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml1.core.impl;

import com.google.common.base.Strings;
import javax.annotation.Nonnull;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.xml.DOMTypeSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.common.AbstractSAMLObjectUnmarshaller;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.saml1.core.RequestAbstractType;
import org.opensaml.saml.saml1.core.RespondWith;
import org.opensaml.xmlsec.signature.Signature;
import org.slf4j.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public abstract class RequestAbstractTypeUnmarshaller
extends AbstractSAMLObjectUnmarshaller {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(RequestAbstractType.class);

    @Nonnull
    public XMLObject unmarshall(@Nonnull Element domElement) throws UnmarshallingException {
        RequestAbstractType request = (RequestAbstractType)super.unmarshall(domElement);
        if (request.getVersion() != SAMLVersion.VERSION_10 && !Strings.isNullOrEmpty((String)request.getID())) {
            XMLObjectSupport.marshallAttributeIDness(null, (String)"RequestID", (Element)domElement, (boolean)true);
        }
        return request;
    }

    protected void processChildElement(@Nonnull XMLObject parentObject, @Nonnull XMLObject childObject) throws UnmarshallingException {
        RequestAbstractType request = (RequestAbstractType)parentObject;
        if (childObject instanceof Signature) {
            request.setSignature((Signature)childObject);
        } else if (childObject instanceof RespondWith) {
            request.getRespondWiths().add((RespondWith)childObject);
        } else {
            super.processChildElement(parentObject, childObject);
        }
    }

    protected void processAttribute(@Nonnull XMLObject xmlObject, @Nonnull Attr attribute) throws UnmarshallingException {
        block17: {
            RequestAbstractType request = (RequestAbstractType)xmlObject;
            if (attribute.getNamespaceURI() == null) {
                if ("RequestID".equals(attribute.getLocalName())) {
                    request.setID(attribute.getValue());
                } else if ("IssueInstant".equals(attribute.getLocalName()) && !Strings.isNullOrEmpty((String)attribute.getValue())) {
                    request.setIssueInstant(DOMTypeSupport.stringToInstant((String)attribute.getValue()));
                } else {
                    if (attribute.getLocalName().equals("MajorVersion")) {
                        try {
                            int major = Integer.parseInt(attribute.getValue());
                            if (major != 1) {
                                throw new UnmarshallingException("MajorVersion was invalid, must be 1");
                            }
                            break block17;
                        }
                        catch (NumberFormatException n) {
                            this.log.error("Failed to parse major version string: {}", (Object)n.getMessage());
                            throw new UnmarshallingException((Exception)n);
                        }
                    }
                    if ("MinorVersion".equals(attribute.getLocalName())) {
                        int minor;
                        try {
                            minor = Integer.parseInt(attribute.getValue());
                        }
                        catch (NumberFormatException n) {
                            this.log.error("Unable to parse minor version string: {}", (Object)n.getMessage());
                            throw new UnmarshallingException((Exception)n);
                        }
                        if (minor == 0) {
                            request.setVersion(SAMLVersion.VERSION_10);
                        } else if (minor == 1) {
                            request.setVersion(SAMLVersion.VERSION_11);
                        }
                    } else {
                        super.processAttribute(xmlObject, attribute);
                    }
                }
            } else {
                super.processAttribute(xmlObject, attribute);
            }
        }
    }
}

