/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.ws.api;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.apache.wicket.Component;
import org.apache.wicket.core.request.handler.AbstractPartialPageRequestHandler;
import org.apache.wicket.core.request.handler.logger.PageLogData;
import org.apache.wicket.page.PartialPageUpdate;
import org.apache.wicket.page.XmlPartialPageUpdate;
import org.apache.wicket.protocol.ws.api.IWebSocketConnection;
import org.apache.wicket.protocol.ws.api.IWebSocketRequestHandler;
import org.apache.wicket.request.ILogData;
import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.Response;
import org.apache.wicket.response.StringResponse;
import org.apache.wicket.util.lang.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketRequestHandler
extends AbstractPartialPageRequestHandler
implements IWebSocketRequestHandler {
    private static final Logger LOG = LoggerFactory.getLogger(WebSocketRequestHandler.class);
    private final IWebSocketConnection connection;
    private PartialPageUpdate update;
    private PageLogData logData;

    public WebSocketRequestHandler(Component component, IWebSocketConnection connection) {
        super(((Component)Args.notNull((Object)component, (String)"component")).getPage());
        this.connection = (IWebSocketConnection)Args.notNull((Object)connection, (String)"connection");
    }

    @Override
    public void push(CharSequence message) {
        if (this.connection.isOpen()) {
            Args.notNull((Object)message, (String)"message");
            try {
                this.connection.sendMessage(message.toString());
            }
            catch (IOException iox) {
                LOG.error("An error occurred while pushing text message.", (Throwable)iox);
            }
        } else {
            LOG.warn("The websocket connection is already closed. Cannot push the text message '{}'", (Object)message);
        }
    }

    @Override
    public Future<Void> pushAsync(CharSequence message, long timeout) {
        if (this.connection.isOpen()) {
            Args.notNull((Object)message, (String)"message");
            return this.connection.sendMessageAsync(message.toString(), timeout);
        }
        LOG.warn("The websocket connection is already closed. Cannot push the text message '{}'", (Object)message);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public Future<Void> pushAsync(CharSequence message) {
        return this.pushAsync(message, -1L);
    }

    @Override
    public void push(byte[] message, int offset, int length) {
        if (this.connection.isOpen()) {
            Args.notNull((Object)message, (String)"message");
            try {
                this.connection.sendMessage(message, offset, length);
            }
            catch (IOException iox) {
                LOG.error("An error occurred while pushing binary message.", (Throwable)iox);
            }
        } else {
            LOG.warn("The websocket connection is already closed. Cannot push the binary message '{}'", (Object)message);
        }
    }

    @Override
    public Future<Void> pushAsync(byte[] message, int offset, int length) {
        return this.pushAsync(message, offset, length, -1L);
    }

    @Override
    public Future<Void> pushAsync(byte[] message, int offset, int length, long timeout) {
        if (this.connection.isOpen()) {
            Args.notNull((Object)message, (String)"message");
            return this.connection.sendMessageAsync(message, offset, length, timeout);
        }
        LOG.warn("The websocket connection is already closed. Cannot push the binary message '{}'", (Object)message);
        return CompletableFuture.completedFuture(null);
    }

    protected boolean shouldPushWhenEmpty() {
        return true;
    }

    protected PartialPageUpdate getUpdate() {
        if (this.update == null) {
            this.update = new XmlPartialPageUpdate(this.getPage());
        }
        return this.update;
    }

    public Collection<? extends Component> getComponents() {
        if (this.update == null) {
            return Collections.emptyList();
        }
        return this.update.getComponents();
    }

    public ILogData getLogData() {
        return this.logData;
    }

    public void respond(IRequestCycle requestCycle) {
        if (this.update != null && (this.shouldPushWhenEmpty() || !this.update.isEmpty())) {
            StringResponse bodyResponse = new StringResponse();
            this.update.writeTo((Response)bodyResponse, requestCycle.getRequest().getCharset().name());
            requestCycle.getResponse().write(bodyResponse.getBuffer());
        }
    }

    public void detach(IRequestCycle requestCycle) {
        if (this.logData == null) {
            this.logData = new PageLogData(this.getPage());
        }
        if (this.update != null) {
            this.update.detach(requestCycle);
            this.update = null;
        }
    }
}

