/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.request.handler.logger;

import org.apache.wicket.request.handler.resource.ResourceLogData;
import org.apache.wicket.request.handler.resource.ResourceStreamRequestHandler;
import org.apache.wicket.request.resource.ContentDisposition;
import org.apache.wicket.util.resource.IResourceStream;

public class ResourceStreamLogData
extends ResourceLogData {
    private static final long serialVersionUID = 1L;
    private final Class<? extends IResourceStream> resourceStreamClass;
    private final ContentDisposition contentDisposition;
    private final String contentType;

    public ResourceStreamLogData(ResourceStreamRequestHandler streamHandler) {
        super(streamHandler.getFileName(), null, null, null);
        this.contentDisposition = streamHandler.getContentDisposition();
        this.resourceStreamClass = null;
        this.contentType = null;
    }

    public ResourceStreamLogData(ResourceStreamRequestHandler streamHandler, IResourceStream stream) {
        super(streamHandler.getFileName(), stream.getLocale(), stream.getStyle(), stream.getVariation());
        this.contentDisposition = streamHandler.getContentDisposition();
        this.resourceStreamClass = stream.getClass();
        this.contentType = stream.getContentType();
    }

    public final Class<? extends IResourceStream> getResourceStreamClass() {
        return this.resourceStreamClass;
    }

    public final ContentDisposition getContentDisposition() {
        return this.contentDisposition;
    }

    public final String getContentType() {
        return this.contentType;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        this.fillToString(sb);
        sb.append(",contentDisposition=");
        sb.append((Object)this.getContentDisposition());
        if (this.getResourceStreamClass() != null) {
            sb.append(",resourceStreamClass=");
            sb.append(this.getResourceStreamClass().getName());
            sb.append(",contentType=");
            sb.append(this.getContentType());
        }
        sb.append("}");
        return sb.toString();
    }
}

