/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.time;

import java.time.Duration;
import java.time.Instant;
import java.util.Locale;
import org.apache.wicket.util.string.StringValue;

public class Durations {
    public static String toString(Duration duration, Locale locale) {
        if (duration.toMillis() >= 0L) {
            if ((double)duration.toDays() >= 1.0) {
                return Durations.unitString(duration.toDays(), "day", locale);
            }
            if ((double)duration.toHours() >= 1.0) {
                return Durations.unitString(duration.toHours(), "hour", locale);
            }
            if ((double)duration.toMinutes() >= 1.0) {
                return Durations.unitString(duration.toMinutes(), "minute", locale);
            }
            if ((double)duration.toSeconds() >= 1.0) {
                return Durations.unitString(duration.toSeconds(), "second", locale);
            }
            return Durations.unitString(duration.toMillis(), "millisecond", locale);
        }
        return "N/A";
    }

    private static String unitString(double value, String units, Locale locale) {
        return String.valueOf(StringValue.valueOf(value, locale)) + " " + units + (value > 1.0 ? "s" : "");
    }

    public static Duration elapsedSince(Instant start) {
        return Duration.between(start, Instant.now());
    }
}

