/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.conversion;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EclipseUserLibrariesHelper {
    private EclipseUserLibrariesHelper() {
    }

    private static void writeUserLibrary(Library library, Element libElement) {
        VirtualFile[] files;
        for (VirtualFile file : files = library.getFiles(OrderRootType.CLASSES)) {
            VirtualFile localFile;
            Element archElement = new Element("archive");
            if (file.getFileSystem() instanceof JarFileSystem && (localFile = JarFileSystem.getInstance().getVirtualFileForJar(file)) != null) {
                file = localFile;
            }
            archElement.setAttribute("path", file.getPath());
            libElement.addContent(archElement);
        }
    }

    public static void appendProjectLibraries(Project project, @Nullable File userLibrariesFile) throws IOException {
        if (userLibrariesFile == null) {
            return;
        }
        if (userLibrariesFile.exists() && !userLibrariesFile.isFile()) {
            return;
        }
        File parentFile = userLibrariesFile.getParentFile();
        if (parentFile == null) {
            return;
        }
        if (!parentFile.isDirectory() && !parentFile.mkdir()) {
            return;
        }
        Element userLibsElement = new Element("eclipse-userlibraries");
        ArrayList<Library> libraries = new ArrayList<Library>(Arrays.asList(LibraryTablesRegistrar.getInstance().getLibraryTable(project).getLibraries()));
        ContainerUtil.addAll(libraries, (Object[])LibraryTablesRegistrar.getInstance().getGlobalLibraryTable(project).getLibraries());
        for (Library library : libraries) {
            Element libElement = new Element("library");
            libElement.setAttribute("name", library.getName());
            EclipseUserLibrariesHelper.writeUserLibrary(library, libElement);
            userLibsElement.addContent(libElement);
        }
        JDOMUtil.writeDocument((Document)new Document(userLibsElement), (File)userLibrariesFile, (String)"\n");
    }

    public static void readProjectLibrariesContent(@NotNull VirtualFile exportedFile, Project project, Collection<String> unknownLibraries) throws IOException, JDOMException {
        if (exportedFile == null) {
            EclipseUserLibrariesHelper.$$$reportNull$$$0(0);
        }
        if (!exportedFile.isValid()) {
            return;
        }
        LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTable(project);
        Element element = JDOMUtil.load((InputStream)exportedFile.getInputStream());
        WriteAction.run(() -> {
            for (Element libElement : element.getChildren("library")) {
                LibraryTable.ModifiableModel model;
                String libName = libElement.getAttributeValue("name");
                Library libraryByName = libraryTable.getLibraryByName(libName);
                if (libraryByName == null) {
                    model = libraryTable.getModifiableModel();
                    libraryByName = model.createLibrary(libName);
                    model.commit();
                }
                model = libraryByName.getModifiableModel();
                for (Element a : libElement.getChildren("archive")) {
                    VirtualFile jarFile;
                    String url;
                    Object rootPath = a.getAttributeValue("path");
                    LocalFileSystem fileSystem = LocalFileSystem.getInstance();
                    VirtualFile localFile = fileSystem.findFileByPath((String)rootPath);
                    if (((String)rootPath).startsWith("/") && (localFile == null || !localFile.isValid())) {
                        rootPath = project.getBasePath() + (String)rootPath;
                        localFile = fileSystem.findFileByPath((String)rootPath);
                    }
                    String string = url = localFile == null ? VfsUtilCore.pathToUrl((String)rootPath) : localFile.getUrl();
                    if (localFile != null && (jarFile = JarFileSystem.getInstance().getJarRootForLocalFile(localFile)) != null) {
                        url = jarFile.getUrl();
                    }
                    model.addRoot(url, OrderRootType.CLASSES);
                }
                model.commit();
                unknownLibraries.remove(libName);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exportedFile", "org/jetbrains/idea/eclipse/conversion/EclipseUserLibrariesHelper", "readProjectLibrariesContent"));
    }
}

