/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.model.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.idea.maven.dom.converters.MavenDependencyCompletionUtil;
import org.jetbrains.idea.maven.dom.model.completion.MavenCoordinateCompletionContributor;
import org.jetbrains.idea.maven.dom.model.completion.insert.MavenTopLevelDependencyInsertionHandler;
import org.jetbrains.idea.maven.onlinecompletion.model.MavenRepositoryArtifactInfo;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.reposearch.DependencySearchService;
import org.jetbrains.idea.reposearch.RepositoryArtifactData;
import org.jetbrains.idea.reposearch.SearchParameters;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J4\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0004J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/idea/maven/dom/model/completion/MavenTopLevelCompletionContributor;", "Lcom/intellij/codeInsight/completion/CompletionContributor;", "myName", "", "<init>", "(Ljava/lang/String;)V", "getMyName", "()Ljava/lang/String;", "fillCompletionVariants", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "find", "Lorg/jetbrains/concurrency/Promise;", "", "project", "Lcom/intellij/openapi/project/Project;", "text", "cld", "Ljava/util/concurrent/ConcurrentLinkedDeque;", "Lorg/jetbrains/idea/maven/onlinecompletion/model/MavenRepositoryArtifactInfo;", "createSearchParameters", "Lorg/jetbrains/idea/reposearch/SearchParameters;", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nMavenTopLevelCompletionContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenTopLevelCompletionContributor.kt\norg/jetbrains/idea/maven/dom/model/completion/MavenTopLevelCompletionContributor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,69:1\n1#2:70\n*E\n"})
public abstract class MavenTopLevelCompletionContributor
extends CompletionContributor {
    @NotNull
    private final String myName;

    public MavenTopLevelCompletionContributor(@NotNull String myName) {
        Intrinsics.checkNotNullParameter((Object)myName, (String)"myName");
        this.myName = myName;
    }

    @NotNull
    public final String getMyName() {
        return this.myName;
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        if (parameters.getCompletionType() != CompletionType.BASIC) {
            return;
        }
        PsiElement psiElement = parameters.getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPosition(...)");
        PsiElement element = psiElement;
        PsiElement psiElement2 = element.getParent();
        XmlText xmlText = psiElement2 instanceof XmlText ? (XmlText)psiElement2 : null;
        if (xmlText == null) {
            return;
        }
        XmlText xmlText2 = xmlText;
        PsiElement parent = xmlText2.getParent();
        if (!(parent instanceof XmlTag) || !Intrinsics.areEqual((Object)((XmlTag)parent).getName(), (Object)this.myName)) {
            return;
        }
        result2.restartCompletionWhenNothingMatches();
        ConcurrentLinkedDeque<MavenRepositoryArtifactInfo> cld = new ConcurrentLinkedDeque<MavenRepositoryArtifactInfo>();
        Project project = xmlText2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Promise<Integer> promise = this.find(project, MavenCoordinateCompletionContributor.Companion.trimDummy(xmlText2.getValue()), parameters, cld);
        while (promise.getState() == Promise.State.PENDING || !cld.isEmpty()) {
            ProgressManager.checkCanceled();
            MavenRepositoryArtifactInfo item = cld.poll();
            if (item == null) continue;
            result2.addElement((LookupElement)MavenDependencyCompletionUtil.lookupElement$default(MavenDependencyCompletionUtil.INSTANCE, item, null, 2, null).withInsertHandler(MavenTopLevelDependencyInsertionHandler.Companion.getINSTANCE()));
        }
    }

    @NotNull
    protected final Promise<Integer> find(@NotNull Project project, @NotNull String text, @NotNull CompletionParameters parameters, @NotNull ConcurrentLinkedDeque<MavenRepositoryArtifactInfo> cld) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter(cld, (String)"cld");
        SearchParameters searchParameters = this.createSearchParameters(parameters);
        String searchString = MavenCoordinateCompletionContributor.Companion.trimDummy(text);
        DependencySearchService service = DependencySearchService.Companion.getInstance(project);
        char[] cArray = new char[]{':'};
        List splitted = StringsKt.split$default((CharSequence)searchString, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        if (splitted.size() < 2) {
            return service.fulltextSearch(searchString, searchParameters, arg_0 -> MavenTopLevelCompletionContributor.find$lambda$0(cld, arg_0));
        }
        return service.suggestPrefix((String)splitted.get(0), (String)splitted.get(1), searchParameters, arg_0 -> MavenTopLevelCompletionContributor.find$lambda$1(cld, arg_0));
    }

    private final SearchParameters createSearchParameters(CompletionParameters parameters) {
        return new SearchParameters(parameters.getInvocationCount() < 2, MavenUtil.isMavenUnitTestModeEnabled());
    }

    private static final Unit find$lambda$0(ConcurrentLinkedDeque $cld, RepositoryArtifactData it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            MavenRepositoryArtifactInfo mavenRepositoryArtifactInfo = it instanceof MavenRepositoryArtifactInfo ? (MavenRepositoryArtifactInfo)it : null;
            if (mavenRepositoryArtifactInfo == null) break block0;
            MavenRepositoryArtifactInfo it2 = mavenRepositoryArtifactInfo;
            boolean bl = false;
            $cld.add(it2);
        }
        return Unit.INSTANCE;
    }

    private static final Unit find$lambda$1(ConcurrentLinkedDeque $cld, RepositoryArtifactData it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            MavenRepositoryArtifactInfo mavenRepositoryArtifactInfo = it instanceof MavenRepositoryArtifactInfo ? (MavenRepositoryArtifactInfo)it : null;
            if (mavenRepositoryArtifactInfo == null) break block0;
            MavenRepositoryArtifactInfo it2 = mavenRepositoryArtifactInfo;
            boolean bl = false;
            $cld.add(it2);
        }
        return Unit.INSTANCE;
    }
}

