/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.model.completion.insert;

import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.converters.MavenDependencyCompletionUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomArtifactCoordinates;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.dom.model.MavenDomShortArtifactCoordinates;
import org.jetbrains.idea.maven.dom.model.completion.insert.MavenDependencyInsertionTrackerKt;
import org.jetbrains.idea.maven.model.MavenCoordinate;
import org.jetbrains.idea.maven.onlinecompletion.MavenScopeTable;
import org.jetbrains.idea.maven.onlinecompletion.model.MavenRepositoryArtifactInfo;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00112\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J*\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/idea/maven/dom/model/completion/insert/MavenDependencyInsertionHandler;", "Lcom/intellij/codeInsight/completion/InsertHandler;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "<init>", "()V", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "setDependency", "completionItem", "Lorg/jetbrains/idea/maven/onlinecompletion/model/MavenRepositoryArtifactInfo;", "contextFile", "Lcom/intellij/psi/xml/XmlFile;", "domCoordinates", "Lorg/jetbrains/idea/maven/dom/model/MavenDomShortArtifactCoordinates;", "Companion", "intellij.maven"})
public class MavenDependencyInsertionHandler
implements InsertHandler<LookupElement> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final InsertHandler<LookupElement> INSTANCE = new MavenDependencyInsertionHandler();

    public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Object object = item.getObject();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getObject(...)");
        Object obj = object;
        if (!(obj instanceof MavenRepositoryArtifactInfo)) {
            return;
        }
        PsiFile psiFile = context2.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        PsiFile contextFile = psiFile;
        if (!(contextFile instanceof XmlFile)) {
            return;
        }
        PsiElement element = contextFile.findElementAt(context2.getStartOffset());
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
        if (tag == null) {
            return;
        }
        context2.commitDocument();
        MavenDomShortArtifactCoordinates domCoordinates = MavenDependencyInsertionHandler.Companion.getDomCoordinatesFromCurrentTag(context2, tag);
        if (domCoordinates == null) {
            return;
        }
        this.setDependency(context2, (MavenRepositoryArtifactInfo)obj, (XmlFile)contextFile, domCoordinates);
        MavenDependencyInsertionTrackerKt.logMavenDependencyInsertion(context2, item, (MavenRepositoryArtifactInfo)obj);
    }

    protected void setDependency(@NotNull InsertionContext context2, @NotNull MavenRepositoryArtifactInfo completionItem, @Nullable XmlFile contextFile, @NotNull MavenDomShortArtifactCoordinates domCoordinates) {
        String scope;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)completionItem, (String)"completionItem");
        Intrinsics.checkNotNullParameter((Object)domCoordinates, (String)"domCoordinates");
        domCoordinates.getGroupId().setStringValue(completionItem.getGroupId());
        domCoordinates.getArtifactId().setStringValue(completionItem.getArtifactId());
        if (domCoordinates instanceof MavenDomDependency && (scope = MavenScopeTable.getUsualScope((MavenCoordinate)completionItem)) != null) {
            ((MavenDomDependency)domCoordinates).getScope().setStringValue(scope);
        }
        DomFileElement domModel = DomManager.getDomManager((Project)context2.getProject()).getFileElement(contextFile, MavenDomProjectModel.class);
        if (!MavenDependencyCompletionUtil.isInsideManagedDependency(domCoordinates)) {
            DomFileElement domFileElement = domModel;
            Intrinsics.checkNotNull((Object)domFileElement);
            DomElement domElement = domFileElement.getRootElement();
            Intrinsics.checkNotNullExpressionValue((Object)domElement, (String)"getRootElement(...)");
            MavenDomProjectModel mavenDomProjectModel = (MavenDomProjectModel)domElement;
            Project project = context2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            MavenDomDependency declarationOfDependency = MavenDependencyCompletionUtil.findManagedDependency(mavenDomProjectModel, project, completionItem.getGroupId(), completionItem.getArtifactId());
            if (declarationOfDependency != null) {
                if (domCoordinates instanceof MavenDomDependency) {
                    if (declarationOfDependency.getType().getRawText() != null) {
                        ((MavenDomDependency)domCoordinates).getType().setStringValue(declarationOfDependency.getType().getRawText());
                    }
                    if (declarationOfDependency.getClassifier().getRawText() != null) {
                        ((MavenDomDependency)domCoordinates).getClassifier().setStringValue(declarationOfDependency.getClassifier().getRawText());
                    }
                }
                return;
            }
        }
        if (domCoordinates instanceof MavenDomArtifactCoordinates) {
            MavenDependencyInsertionHandler.Companion.insertVersion(context2, completionItem, (MavenDomArtifactCoordinates)domCoordinates);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0019\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/idea/maven/dom/model/completion/insert/MavenDependencyInsertionHandler$Companion;", "", "<init>", "()V", "INSTANCE", "Lcom/intellij/codeInsight/completion/InsertHandler;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "getINSTANCE", "()Lcom/intellij/codeInsight/completion/InsertHandler;", "getDomCoordinatesFromCurrentTag", "Lorg/jetbrains/idea/maven/dom/model/MavenDomShortArtifactCoordinates;", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "tag", "Lcom/intellij/psi/xml/XmlTag;", "insertVersion", "", "completionItem", "Lorg/jetbrains/idea/maven/onlinecompletion/model/MavenRepositoryArtifactInfo;", "domCoordinates", "Lorg/jetbrains/idea/maven/dom/model/MavenDomArtifactCoordinates;", "intellij.maven"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final InsertHandler<LookupElement> getINSTANCE() {
            return INSTANCE;
        }

        private final MavenDomShortArtifactCoordinates getDomCoordinatesFromCurrentTag(InsertionContext context2, XmlTag tag) {
            DomElement element = DomManager.getDomManager((Project)context2.getProject()).getDomElement(tag);
            if (element instanceof MavenDomShortArtifactCoordinates) {
                tag.getValue().setText("");
                return (MavenDomShortArtifactCoordinates)element;
            }
            element = DomManager.getDomManager((Project)context2.getProject()).getDomElement(tag.getParentTag());
            if (element instanceof MavenDomShortArtifactCoordinates) {
                return (MavenDomShortArtifactCoordinates)element;
            }
            return null;
        }

        private final void insertVersion(InsertionContext context2, MavenRepositoryArtifactInfo completionItem, MavenDomArtifactCoordinates domCoordinates) {
            if (completionItem.getItems().length == 1 && completionItem.getVersion() != null) {
                domCoordinates.getVersion().setStringValue(completionItem.getVersion());
            } else {
                domCoordinates.getVersion().setStringValue("");
                XmlTag xmlTag = domCoordinates.getVersion().getXmlTag();
                Intrinsics.checkNotNull((Object)xmlTag);
                int versionPosition = xmlTag.getValue().getTextRange().getStartOffset();
                context2.getEditor().getCaretModel().moveToOffset(versionPosition);
                MavenDependencyCompletionUtil.invokeCompletion(context2, CompletionType.BASIC);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

