/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import org.apache.lucene.index.Payload;
import org.apache.lucene.util.ArrayUtil;

public class Token
implements Cloneable {
    public static final String DEFAULT_TYPE = "word";
    private static int MIN_BUFFER_SIZE;
    private String termText;
    char[] termBuffer;
    int termLength;
    int startOffset;
    int endOffset;
    String type = "word";
    private int flags;
    Payload payload;
    int positionIncrement = 1;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Token() {
    }

    public Token(int start, int end) {
        this.startOffset = start;
        this.endOffset = end;
    }

    public Token(int start, int end, String typ) {
        this.startOffset = start;
        this.endOffset = end;
        this.type = typ;
    }

    public Token(int start, int end, int flags) {
        this.startOffset = start;
        this.endOffset = end;
        this.flags = flags;
    }

    public Token(String text, int start, int end) {
        this.termText = text;
        this.startOffset = start;
        this.endOffset = end;
    }

    public Token(String text, int start, int end, String typ) {
        this.termText = text;
        this.startOffset = start;
        this.endOffset = end;
        this.type = typ;
    }

    public Token(String text, int start, int end, int flags) {
        this.termText = text;
        this.startOffset = start;
        this.endOffset = end;
        this.flags = flags;
    }

    public Token(char[] startTermBuffer, int termBufferOffset, int termBufferLength, int start, int end) {
        this.setTermBuffer(startTermBuffer, termBufferOffset, termBufferLength);
        this.startOffset = start;
        this.endOffset = end;
    }

    public void setPositionIncrement(int positionIncrement) {
        if (positionIncrement < 0) {
            throw new IllegalArgumentException("Increment must be zero or greater: " + positionIncrement);
        }
        this.positionIncrement = positionIncrement;
    }

    public int getPositionIncrement() {
        return this.positionIncrement;
    }

    public void setTermText(String text) {
        this.termText = text;
        this.termBuffer = null;
    }

    public final String termText() {
        if (this.termText == null && this.termBuffer != null) {
            this.termText = new String(this.termBuffer, 0, this.termLength);
        }
        return this.termText;
    }

    public final String term() {
        if (this.termText != null) {
            return this.termText;
        }
        this.initTermBuffer();
        return new String(this.termBuffer, 0, this.termLength);
    }

    public final void setTermBuffer(char[] buffer, int offset, int length) {
        this.termText = null;
        char[] newCharBuffer = this.growTermBuffer(length);
        if (newCharBuffer != null) {
            this.termBuffer = newCharBuffer;
        }
        System.arraycopy(buffer, offset, this.termBuffer, 0, length);
        this.termLength = length;
    }

    public final void setTermBuffer(String buffer) {
        this.termText = null;
        int length = buffer.length();
        char[] newCharBuffer = this.growTermBuffer(length);
        if (newCharBuffer != null) {
            this.termBuffer = newCharBuffer;
        }
        buffer.getChars(0, length, this.termBuffer, 0);
        this.termLength = length;
    }

    public final void setTermBuffer(String buffer, int offset, int length) {
        if (!$assertionsDisabled && offset > buffer.length()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && offset + length > buffer.length()) {
            throw new AssertionError();
        }
        this.termText = null;
        char[] newCharBuffer = this.growTermBuffer(length);
        if (newCharBuffer != null) {
            this.termBuffer = newCharBuffer;
        }
        buffer.getChars(offset, offset + length, this.termBuffer, 0);
        this.termLength = length;
    }

    public final char[] termBuffer() {
        this.initTermBuffer();
        return this.termBuffer;
    }

    public char[] resizeTermBuffer(int newSize) {
        char[] newCharBuffer = this.growTermBuffer(newSize);
        if (this.termBuffer == null) {
            if (!$assertionsDisabled && newCharBuffer == null) {
                throw new AssertionError();
            }
            if (this.termText != null) {
                this.termText.getChars(0, this.termText.length(), newCharBuffer, 0);
            }
            this.termBuffer = newCharBuffer;
        } else if (newCharBuffer != null) {
            System.arraycopy(this.termBuffer, 0, newCharBuffer, 0, this.termBuffer.length);
            this.termBuffer = newCharBuffer;
        }
        this.termText = null;
        return this.termBuffer;
    }

    private char[] growTermBuffer(int newSize) {
        int ttLength;
        if (this.termBuffer != null) {
            if (this.termBuffer.length >= newSize) {
                return null;
            }
            return new char[ArrayUtil.getNextSize(newSize)];
        }
        if (newSize < MIN_BUFFER_SIZE) {
            newSize = MIN_BUFFER_SIZE;
        }
        if (this.termText != null && newSize < (ttLength = this.termText.length())) {
            newSize = ttLength;
        }
        return new char[newSize];
    }

    private void initTermBuffer() {
        if (this.termBuffer == null) {
            if (this.termText == null) {
                this.termBuffer = new char[MIN_BUFFER_SIZE];
                this.termLength = 0;
            } else {
                int length = this.termText.length();
                if (length < MIN_BUFFER_SIZE) {
                    length = MIN_BUFFER_SIZE;
                }
                this.termBuffer = new char[length];
                this.termLength = this.termText.length();
                this.termText.getChars(0, this.termText.length(), this.termBuffer, 0);
                this.termText = null;
            }
        } else if (this.termText != null) {
            this.termText = null;
        }
    }

    public final int termLength() {
        this.initTermBuffer();
        return this.termLength;
    }

    public final void setTermLength(int length) {
        this.initTermBuffer();
        if (length > this.termBuffer.length) {
            throw new IllegalArgumentException("length " + length + " exceeds the size of the termBuffer (" + this.termBuffer.length + ")");
        }
        this.termLength = length;
    }

    public final int startOffset() {
        return this.startOffset;
    }

    public void setStartOffset(int offset) {
        this.startOffset = offset;
    }

    public final int endOffset() {
        return this.endOffset;
    }

    public void setEndOffset(int offset) {
        this.endOffset = offset;
    }

    public final String type() {
        return this.type;
    }

    public final void setType(String type) {
        this.type = type;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public Payload getPayload() {
        return this.payload;
    }

    public void setPayload(Payload payload) {
        this.payload = payload;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('(');
        this.initTermBuffer();
        if (this.termBuffer == null) {
            sb.append("null");
        } else {
            sb.append(this.termBuffer, 0, this.termLength);
        }
        sb.append(',').append(this.startOffset).append(',').append(this.endOffset);
        if (!this.type.equals(DEFAULT_TYPE)) {
            sb.append(",type=").append(this.type);
        }
        if (this.positionIncrement != 1) {
            sb.append(",posIncr=").append(this.positionIncrement);
        }
        sb.append(')');
        return sb.toString();
    }

    public void clear() {
        this.payload = null;
        this.termLength = 0;
        this.termText = null;
        this.positionIncrement = 1;
        this.flags = 0;
    }

    public Object clone() {
        try {
            Token t = (Token)super.clone();
            if (this.termBuffer != null) {
                t.termBuffer = (char[])this.termBuffer.clone();
            }
            if (this.payload != null) {
                t.setPayload((Payload)this.payload.clone());
            }
            return t;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public Token clone(char[] newTermBuffer, int newTermOffset, int newTermLength, int newStartOffset, int newEndOffset) {
        Token t = new Token(newTermBuffer, newTermOffset, newTermLength, newStartOffset, newEndOffset);
        t.positionIncrement = this.positionIncrement;
        t.flags = this.flags;
        t.type = this.type;
        if (this.payload != null) {
            t.payload = (Payload)this.payload.clone();
        }
        return t;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Token) {
            Token other = (Token)obj;
            this.initTermBuffer();
            other.initTermBuffer();
            if (this.termLength == other.termLength && this.startOffset == other.startOffset && this.endOffset == other.endOffset && this.flags == other.flags && this.positionIncrement == other.positionIncrement && this.subEqual(this.type, other.type) && this.subEqual(this.payload, other.payload)) {
                for (int i = 0; i < this.termLength; ++i) {
                    if (this.termBuffer[i] == other.termBuffer[i]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean subEqual(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    public int hashCode() {
        this.initTermBuffer();
        int code = this.termLength;
        code = code * 31 + this.startOffset;
        code = code * 31 + this.endOffset;
        code = code * 31 + this.flags;
        code = code * 31 + this.positionIncrement;
        code = code * 31 + this.type.hashCode();
        code = this.payload == null ? code : code * 31 + this.payload.hashCode();
        code = code * 31 + ArrayUtil.hashCode(this.termBuffer, 0, this.termLength);
        return code;
    }

    private void clearNoTermBuffer() {
        this.payload = null;
        this.positionIncrement = 1;
        this.flags = 0;
    }

    public Token reinit(char[] newTermBuffer, int newTermOffset, int newTermLength, int newStartOffset, int newEndOffset, String newType) {
        this.clearNoTermBuffer();
        this.payload = null;
        this.positionIncrement = 1;
        this.setTermBuffer(newTermBuffer, newTermOffset, newTermLength);
        this.startOffset = newStartOffset;
        this.endOffset = newEndOffset;
        this.type = newType;
        return this;
    }

    public Token reinit(char[] newTermBuffer, int newTermOffset, int newTermLength, int newStartOffset, int newEndOffset) {
        this.clearNoTermBuffer();
        this.setTermBuffer(newTermBuffer, newTermOffset, newTermLength);
        this.startOffset = newStartOffset;
        this.endOffset = newEndOffset;
        this.type = DEFAULT_TYPE;
        return this;
    }

    public Token reinit(String newTerm, int newStartOffset, int newEndOffset, String newType) {
        this.clearNoTermBuffer();
        this.setTermBuffer(newTerm);
        this.startOffset = newStartOffset;
        this.endOffset = newEndOffset;
        this.type = newType;
        return this;
    }

    public Token reinit(String newTerm, int newTermOffset, int newTermLength, int newStartOffset, int newEndOffset, String newType) {
        this.clearNoTermBuffer();
        this.setTermBuffer(newTerm, newTermOffset, newTermLength);
        this.startOffset = newStartOffset;
        this.endOffset = newEndOffset;
        this.type = newType;
        return this;
    }

    public Token reinit(String newTerm, int newStartOffset, int newEndOffset) {
        this.clearNoTermBuffer();
        this.setTermBuffer(newTerm);
        this.startOffset = newStartOffset;
        this.endOffset = newEndOffset;
        this.type = DEFAULT_TYPE;
        return this;
    }

    public Token reinit(String newTerm, int newTermOffset, int newTermLength, int newStartOffset, int newEndOffset) {
        this.clearNoTermBuffer();
        this.setTermBuffer(newTerm, newTermOffset, newTermLength);
        this.startOffset = newStartOffset;
        this.endOffset = newEndOffset;
        this.type = DEFAULT_TYPE;
        return this;
    }

    public void reinit(Token prototype) {
        prototype.initTermBuffer();
        this.setTermBuffer(prototype.termBuffer, 0, prototype.termLength);
        this.positionIncrement = prototype.positionIncrement;
        this.flags = prototype.flags;
        this.startOffset = prototype.startOffset;
        this.endOffset = prototype.endOffset;
        this.type = prototype.type;
        this.payload = prototype.payload;
    }

    public void reinit(Token prototype, String newTerm) {
        this.setTermBuffer(newTerm);
        this.positionIncrement = prototype.positionIncrement;
        this.flags = prototype.flags;
        this.startOffset = prototype.startOffset;
        this.endOffset = prototype.endOffset;
        this.type = prototype.type;
        this.payload = prototype.payload;
    }

    public void reinit(Token prototype, char[] newTermBuffer, int offset, int length) {
        this.setTermBuffer(newTermBuffer, offset, length);
        this.positionIncrement = prototype.positionIncrement;
        this.flags = prototype.flags;
        this.startOffset = prototype.startOffset;
        this.endOffset = prototype.endOffset;
        this.type = prototype.type;
        this.payload = prototype.payload;
    }

    static {
        $assertionsDisabled = !Token.class.desiredAssertionStatus();
        MIN_BUFFER_SIZE = 10;
    }
}

