/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.query.lucenelib;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import lombok.Generated;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FieldExistsQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.opensearch.knn.index.query.common.QueryUtils;
import org.opensearch.knn.index.query.lucenelib.InternalNestedKnnVectorQuery;

public class ExpandNestedDocsQuery
extends Query {
    private final InternalNestedKnnVectorQuery internalNestedKnnVectorQuery;
    private final QueryUtils queryUtils;

    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        Query docAndScoreQuery = this.internalNestedKnnVectorQuery.knnRewrite(searcher);
        Weight weight = docAndScoreQuery.createWeight(searcher, scoreMode, boost);
        IndexReader reader = searcher.getIndexReader();
        List leafReaderContexts = reader.leaves();
        List<Map<Integer, Float>> perLeafResults = this.queryUtils.doSearch(searcher, leafReaderContexts, weight);
        TopDocs[] topDocs = this.retrieveAll(searcher, leafReaderContexts, perLeafResults);
        int sum = 0;
        for (TopDocs topDoc : topDocs) {
            sum += topDoc.scoreDocs.length;
        }
        TopDocs topK = TopDocs.merge((int)sum, (TopDocs[])topDocs);
        if (topK.scoreDocs.length == 0) {
            return new MatchNoDocsQuery().createWeight(searcher, scoreMode, boost);
        }
        return this.queryUtils.createDocAndScoreQuery(reader, topK).createWeight(searcher, scoreMode, boost);
    }

    private TopDocs[] retrieveAll(IndexSearcher indexSearcher, List<LeafReaderContext> leafReaderContexts, List<Map<Integer, Float>> perLeafResults) throws IOException {
        ArrayList<Callable<TopDocs>> nestedQueryTasks = new ArrayList<Callable<TopDocs>>(leafReaderContexts.size());
        Weight filterWeight = this.getFilterWeight(indexSearcher);
        int i = 0;
        while (i < perLeafResults.size()) {
            LeafReaderContext leafReaderContext = leafReaderContexts.get(i);
            int finalI = i++;
            nestedQueryTasks.add(() -> {
                Bits queryFilter = this.queryUtils.createBits(leafReaderContext, filterWeight);
                DocIdSetIterator allSiblings = this.queryUtils.getAllSiblings(leafReaderContext, ((Map)perLeafResults.get(finalI)).keySet(), this.internalNestedKnnVectorQuery.getParentFilter(), queryFilter);
                TopDocs topDocs = this.internalNestedKnnVectorQuery.knnExactSearch(leafReaderContext, allSiblings);
                for (ScoreDoc scoreDoc : topDocs.scoreDocs) {
                    scoreDoc.doc += leafReaderContext.docBase;
                }
                return topDocs;
            });
        }
        return (TopDocs[])indexSearcher.getTaskExecutor().invokeAll(nestedQueryTasks).toArray(TopDocs[]::new);
    }

    private Weight getFilterWeight(IndexSearcher indexSearcher) throws IOException {
        if (this.internalNestedKnnVectorQuery.getFilter() == null) {
            return null;
        }
        BooleanQuery booleanQuery = new BooleanQuery.Builder().add(this.internalNestedKnnVectorQuery.getFilter(), BooleanClause.Occur.FILTER).add((Query)new FieldExistsQuery(this.internalNestedKnnVectorQuery.getField()), BooleanClause.Occur.FILTER).build();
        Query rewritten = indexSearcher.rewrite((Query)booleanQuery);
        return indexSearcher.createWeight(rewritten, ScoreMode.COMPLETE_NO_SCORES, 1.0f);
    }

    public void visit(QueryVisitor queryVisitor) {
        queryVisitor.visitLeaf((Query)this);
    }

    public boolean equals(Object o) {
        if (!this.sameClassAs(o)) {
            return false;
        }
        ExpandNestedDocsQuery other = (ExpandNestedDocsQuery)((Object)o);
        return this.internalNestedKnnVectorQuery.equals(other.internalNestedKnnVectorQuery);
    }

    public int hashCode() {
        return this.internalNestedKnnVectorQuery.hashCode();
    }

    public String toString(String s) {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[" + this.internalNestedKnnVectorQuery.getField() + "]..." + this.internalNestedKnnVectorQuery.getClass().getSimpleName() + "[" + this.internalNestedKnnVectorQuery.toString() + "]";
    }

    @Generated
    ExpandNestedDocsQuery(InternalNestedKnnVectorQuery internalNestedKnnVectorQuery, QueryUtils queryUtils) {
        this.internalNestedKnnVectorQuery = internalNestedKnnVectorQuery;
        this.queryUtils = queryUtils;
    }

    @Generated
    public static ExpandNestedDocsQueryBuilder builder() {
        return new ExpandNestedDocsQueryBuilder();
    }

    @Generated
    public static class ExpandNestedDocsQueryBuilder {
        @Generated
        private InternalNestedKnnVectorQuery internalNestedKnnVectorQuery;
        @Generated
        private QueryUtils queryUtils;

        @Generated
        ExpandNestedDocsQueryBuilder() {
        }

        @Generated
        public ExpandNestedDocsQueryBuilder internalNestedKnnVectorQuery(InternalNestedKnnVectorQuery internalNestedKnnVectorQuery) {
            this.internalNestedKnnVectorQuery = internalNestedKnnVectorQuery;
            return this;
        }

        @Generated
        public ExpandNestedDocsQueryBuilder queryUtils(QueryUtils queryUtils) {
            this.queryUtils = queryUtils;
            return this;
        }

        @Generated
        public ExpandNestedDocsQuery build() {
            return new ExpandNestedDocsQuery(this.internalNestedKnnVectorQuery, this.queryUtils);
        }

        @Generated
        public String toString() {
            return "ExpandNestedDocsQuery.ExpandNestedDocsQueryBuilder(internalNestedKnnVectorQuery=" + String.valueOf(this.internalNestedKnnVectorQuery) + ", queryUtils=" + String.valueOf(this.queryUtils) + ")";
        }
    }
}

