#  Copyright 2000-2025 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.

from typing import Any

class MutableBase:
    @classmethod
    def coerce(cls, key, value) -> None: ...

class Mutable(MutableBase):
    def changed(self) -> None: ...
    @classmethod
    def associate_with_attribute(cls, attribute) -> None: ...
    @classmethod
    def associate_with(cls, sqltype) -> None: ...
    @classmethod
    def as_mutable(cls, sqltype): ...

class MutableComposite(MutableBase):
    def changed(self) -> None: ...

class MutableDict(Mutable, dict[Any, Any]):
    def __setitem__(self, key, value) -> None: ...
    def setdefault(self, key, value): ...
    def __delitem__(self, key) -> None: ...
    def update(self, *a, **kw) -> None: ...
    def pop(self, *arg): ...
    def popitem(self): ...
    def clear(self) -> None: ...
    @classmethod
    def coerce(cls, key, value): ...

class MutableList(Mutable, list[Any]):
    def __reduce_ex__(self, proto): ...
    def __setitem__(self, index, value) -> None: ...
    def __setslice__(self, start, end, value) -> None: ...
    def __delitem__(self, index) -> None: ...
    def __delslice__(self, start, end) -> None: ...
    def pop(self, *arg): ...
    def append(self, x) -> None: ...
    def extend(self, x) -> None: ...
    def __iadd__(self, x): ...  # type: ignore[misc]
    def insert(self, i, x) -> None: ...
    def remove(self, i) -> None: ...
    def clear(self) -> None: ...
    def sort(self, **kw) -> None: ...
    def reverse(self) -> None: ...
    @classmethod
    def coerce(cls, index, value): ...

class MutableSet(Mutable, set[Any]):
    def update(self, *arg) -> None: ...
    def intersection_update(self, *arg) -> None: ...
    def difference_update(self, *arg) -> None: ...
    def symmetric_difference_update(self, *arg) -> None: ...
    def __ior__(self, other): ...  # type: ignore[misc]
    def __iand__(self, other): ...  # type: ignore[misc]
    def __ixor__(self, other): ...  # type: ignore[misc]
    def __isub__(self, other): ...  # type: ignore[misc]
    def add(self, elem) -> None: ...
    def remove(self, elem) -> None: ...
    def discard(self, elem) -> None: ...
    def pop(self, *arg): ...
    def clear(self) -> None: ...
    @classmethod
    def coerce(cls, index, value): ...
    def __reduce_ex__(self, proto): ...
