/*
 * Decompiled with CFR 0.152.
 */
package io.github.dan2097.jnarinchi;

import io.github.dan2097.jnarinchi.Output;
import io.github.dan2097.jnarinchi.ReactionComponentRole;
import io.github.dan2097.jnarinchi.ReactionDirection;
import io.github.dan2097.jnarinchi.Status;

public class RinchiDecompositionOutput
extends Output {
    private static final int ARRAY_IS_NULL = -1;
    private final ReactionDirection direction;
    private final String[] inchis;
    private final String[] auxInfos;
    private final ReactionComponentRole[] roles;

    public RinchiDecompositionOutput(ReactionDirection direction, String[] inchis, String[] auxInfos, ReactionComponentRole[] roles, Status status, int errorCode, String errorMessage) {
        super(status, errorCode, errorMessage);
        int noElementsRoles;
        this.direction = direction;
        int noElementsInchis = inchis == null ? -1 : inchis.length;
        int noElementsAuxInfo = auxInfos == null ? -1 : auxInfos.length;
        int n = noElementsRoles = roles == null ? -1 : roles.length;
        if (noElementsInchis != noElementsAuxInfo || noElementsAuxInfo != noElementsRoles) {
            throw new IllegalArgumentException("The number of InChIs (" + noElementsInchis + "), auxiliary information (" + noElementsAuxInfo + ") and reaction component roles (" + noElementsRoles + ") must be equal.");
        }
        this.inchis = inchis;
        this.auxInfos = auxInfos;
        this.roles = roles;
    }

    public ReactionDirection getDirection() {
        return this.direction;
    }

    public String[] getInchis() {
        return this.inchis;
    }

    public String[] getAuxInfos() {
        return this.auxInfos;
    }

    public ReactionComponentRole[] getRoles() {
        return this.roles;
    }

    public int getNumberOfComponents() {
        if (this.inchis == null) {
            return 0;
        }
        return this.inchis.length;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append("={reactionDirection=");
        stringBuilder.append((Object)this.direction);
        stringBuilder.append(", inchis=");
        stringBuilder.append(this.arrayElementsToString(this.inchis));
        stringBuilder.append(", auxInfo=");
        stringBuilder.append(this.arrayElementsToString(this.auxInfos));
        stringBuilder.append(", reactionComponentRole=");
        stringBuilder.append(this.arrayElementsToString((Object[])this.roles));
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String arrayElementsToString(Object[] array) {
        StringBuilder stringBuilder = new StringBuilder();
        if (array == null) {
            stringBuilder.append("null");
        } else {
            stringBuilder.append("[");
            for (Object object : array) {
                stringBuilder.append(object.toString());
                stringBuilder.append(", ");
            }
            stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
            stringBuilder.append("]");
        }
        return stringBuilder.toString();
    }
}

