/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import javajs.util.AU;
import javajs.util.BS;
import org.jmol.c.PAL;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelSet;
import org.jmol.modelsetbio.BioModel;
import org.jmol.util.C;
import org.jmol.util.ColorEncoder;
import org.jmol.util.Elements;
import org.jmol.util.GData;
import org.jmol.util.Logger;
import org.jmol.viewer.JC;
import org.jmol.viewer.Viewer;

public class ColorManager {
    public ColorEncoder ce;
    private Viewer vwr;
    private GData g3d;
    private int[] argbsCpk;
    private int[] altArgbsCpk;
    private float[] colorData;
    boolean isDefaultColorRasmol;
    public short colixRubberband = (short)22;
    public short colixBackgroundContrast;

    ColorManager(Viewer vwr, GData gdata) {
        this.vwr = vwr;
        this.ce = new ColorEncoder(null, vwr);
        this.g3d = gdata;
        this.argbsCpk = PAL.argbsCpk;
        this.altArgbsCpk = AU.arrayCopyRangeI(JC.altArgbsCpk, 0, -1);
    }

    void setDefaultColors(boolean isRasmol) {
        if (isRasmol) {
            this.isDefaultColorRasmol = true;
            this.argbsCpk = AU.arrayCopyI(ColorEncoder.getRasmolScale(), -1);
        } else {
            this.isDefaultColorRasmol = false;
            this.argbsCpk = PAL.argbsCpk;
        }
        this.altArgbsCpk = AU.arrayCopyRangeI(JC.altArgbsCpk, 0, -1);
        this.ce.createColorScheme(isRasmol ? "Rasmol=" : "Jmol=", true, true);
        int i = PAL.argbsCpk.length;
        while (--i >= 0) {
            this.g3d.changeColixArgb(i, this.argbsCpk[i]);
        }
        i = JC.altArgbsCpk.length;
        while (--i >= 0) {
            this.g3d.changeColixArgb(Elements.elementNumberMax + i, this.altArgbsCpk[i]);
        }
    }

    public void setRubberbandArgb(int argb) {
        this.colixRubberband = argb == 0 ? (short)0 : C.getColix(argb);
    }

    void setColixBackgroundContrast(int argb) {
        this.colixBackgroundContrast = C.getBgContrast(argb);
    }

    public short getColixBondPalette(Bond bond, int pid) {
        int argb = 0;
        switch (pid) {
            case 19: {
                return this.ce.getColorIndexFromPalette(bond.getEnergy(), -2.5f, -0.5f, 7, false);
            }
        }
        return argb == 0 ? (short)10 : (short)C.getColix(argb);
    }

    public short getColixAtomPalette(Atom atom, byte pid) {
        int argb = 0;
        ModelSet modelSet = this.vwr.ms;
        switch (pid) {
            case 84: {
                return this.colorData == null || atom.i >= this.colorData.length || Float.isNaN(this.colorData[atom.i]) ? (short)12 : this.ce.getColorIndex(this.colorData[atom.i]);
            }
            case 0: 
            case 1: {
                int id;
                int[] a = this.argbsCpk;
                int i = id = atom.getAtomicAndIsotopeNumber();
                if (i >= Elements.elementNumberMax) {
                    id = Elements.altElementIndexFromNumber(i);
                    if (id > 0) {
                        i = id;
                        id += Elements.elementNumberMax;
                        a = this.altArgbsCpk;
                    } else {
                        i = id = Elements.getElementNumber(i);
                    }
                }
                return this.g3d.getChangeableColix(id, a[i]);
            }
            case 2: {
                int index = ColorEncoder.quantize4(atom.getPartialCharge(), -1.0f, 1.0f, JC.PARTIAL_CHARGE_RANGE_SIZE);
                return this.g3d.getChangeableColix(JC.PARTIAL_CHARGE_COLIX_RED + index, JC.argbsRwbScale[index]);
            }
            case 3: {
                int index = atom.getFormalCharge() - -4;
                return this.g3d.getChangeableColix(JC.FORMAL_CHARGE_COLIX_RED + index, JC.argbsFormalCharge[index]);
            }
            case 5: 
            case 68: {
                float hi;
                float lo;
                if (pid == 68) {
                    lo = this.vwr.ms.getBfactor100Lo();
                    hi = this.vwr.ms.getBfactor100Hi();
                } else {
                    lo = 0.0f;
                    hi = 10000.0f;
                }
                return this.ce.getColorIndexFromPalette(atom.getBfactor100(), lo, hi, 7, false);
            }
            case 86: {
                return this.ce.getColorIndexFromPalette(atom.group.getGroupParameter(1111490574), -1.0f, 1.0f, 7, false);
            }
            case 70: {
                float hi = this.vwr.ms.getSurfaceDistanceMax();
                return this.ce.getColorIndexFromPalette(atom.getSurfaceDistance100(), 0.0f, hi, 7, false);
            }
            case 24: {
                int id = atom.group.groupID;
                if (id >= 42) {
                    id = 24 + "PGCATU".indexOf(Character.toUpperCase(atom.group.group1)) - 1;
                }
                return this.ce.getColorIndexFromPalette(id, 0.0f, 0.0f, 17, false);
            }
            case 8: {
                return this.ce.getColorIndexFromPalette(atom.group.groupID, 0.0f, 0.0f, 5, false);
            }
            case 9: {
                return this.ce.getColorIndexFromPalette(atom.group.groupID, 0.0f, 0.0f, 4, false);
            }
            case 75: {
                return this.ce.getColorIndexFromPalette(atom.group.selectedIndex, 0.0f, atom.group.chain.selectedGroupCount - 1, 1, false);
            }
            case 87: {
                Model m = this.vwr.ms.am[atom.mi];
                return this.ce.getColorIndexFromPalette(atom.group.getBioPolymerIndexInModel(), 0.0f, (m.isBioModel ? ((BioModel)m).getBioPolymerCount() : 0) - 1, 1, false);
            }
            case 76: {
                return this.ce.getColorIndexFromPalette(atom.group.getSelectedMonomerIndex(), 0.0f, atom.group.getSelectedMonomerCount() - 1, 1, false);
            }
            case 77: {
                return this.ce.getColorIndexFromPalette(modelSet.getMoleculeIndex(atom.i, true), 0.0f, modelSet.getMoleculeCountInModel(atom.mi) - 1, 0, false);
            }
            case 14: {
                short modelIndex = atom.mi;
                return this.ce.getColorIndexFromPalette(modelSet.getAltLocIndexInModel(modelIndex, atom.altloc), 0.0f, modelSet.getAltLocCountInModel(modelIndex), 0, false);
            }
            case 15: {
                short modelIndex = atom.mi;
                return this.ce.getColorIndexFromPalette(modelSet.getInsertionCodeIndexInModel(modelIndex, atom.group.getInsertionCode()), 0.0f, modelSet.getInsertionCountInModel(modelIndex), 0, false);
            }
            case 16: {
                int id = atom.getAtomicAndIsotopeNumber();
                argb = this.getJmolOrRasmolArgb(id, 1073741991);
                break;
            }
            case 17: {
                int id = atom.getAtomicAndIsotopeNumber();
                argb = this.getJmolOrRasmolArgb(id, 1073742116);
                break;
            }
            case 7: {
                argb = atom.group.getProteinStructureSubType().getColor();
                break;
            }
            case 10: {
                int chain = atom.getChainID();
                if (ColorEncoder.argbsChainAtom == null) {
                    ColorEncoder.argbsChainAtom = this.getArgbs(1153433601);
                    ColorEncoder.argbsChainHetero = this.getArgbs(0x60200006);
                }
                chain = ((chain < 0 ? 0 : (chain >= 256 ? chain - 256 : chain)) & 0x1F) % ColorEncoder.argbsChainAtom.length;
                argb = (atom.isHetero() ? ColorEncoder.argbsChainHetero : ColorEncoder.argbsChainAtom)[chain];
            }
        }
        return argb == 0 ? (short)22 : (short)C.getColix(argb);
    }

    private int[] getArgbs(int tok) {
        return this.vwr.getJBR().getArgbs(tok);
    }

    private int getJmolOrRasmolArgb(int id, int argb) {
        switch (argb) {
            case 1073741991: {
                if (id >= Elements.elementNumberMax) break;
                return this.ce.getArgbFromPalette(id, 0.0f, 0.0f, 2);
            }
            case 1073742116: {
                if (id >= Elements.elementNumberMax) break;
                return this.ce.getArgbFromPalette(id, 0.0f, 0.0f, 3);
            }
            default: {
                return argb;
            }
        }
        return JC.altArgbsCpk[Elements.altElementIndexFromNumber(id)];
    }

    public short getElementColix(int elemNo) {
        int[] a = this.argbsCpk;
        int i = elemNo;
        if (i > Elements.elementNumberMax) {
            int ialt = Elements.altElementIndexFromNumber(i);
            if (ialt > 0) {
                i = ialt;
                a = this.altArgbsCpk;
            } else {
                i = Elements.getElementNumber(i);
            }
        }
        return C.getColix(a[i]);
    }

    public void setElementArgb(int elemNo, int argb) {
        int id;
        if (argb == 1073741991 && this.argbsCpk == PAL.argbsCpk) {
            return;
        }
        argb = this.getJmolOrRasmolArgb(elemNo, argb);
        if (this.argbsCpk == PAL.argbsCpk) {
            this.argbsCpk = AU.arrayCopyRangeI(PAL.argbsCpk, 0, -1);
            this.altArgbsCpk = AU.arrayCopyRangeI(JC.altArgbsCpk, 0, -1);
        }
        if ((id = elemNo) < Elements.elementNumberMax) {
            this.argbsCpk[id] = argb;
        } else {
            id = Elements.altElementIndexFromNumber(elemNo);
            this.altArgbsCpk[id] = argb;
            id += Elements.elementNumberMax;
        }
        this.g3d.changeColixArgb(id, argb);
        this.vwr.setModelkitPropertySafely("updatemodelkeys", null);
    }

    float[] getPropertyColorRange() {
        float[] fArray;
        if (this.ce.isReversed) {
            float[] fArray2 = new float[2];
            fArray2[0] = this.ce.hi;
            fArray = fArray2;
            fArray2[1] = this.ce.lo;
        } else {
            float[] fArray3 = new float[2];
            fArray3[0] = this.ce.lo;
            fArray = fArray3;
            fArray3[1] = this.ce.hi;
        }
        return fArray;
    }

    public void setPropertyColorRangeData(float[] data, BS bs) {
        int i0;
        this.colorData = data;
        this.ce.currentPalette = this.ce.createColorScheme(this.vwr.g.propertyColorScheme, true, false);
        this.ce.hi = -3.4028235E38f;
        this.ce.lo = Float.MAX_VALUE;
        if (data == null) {
            return;
        }
        boolean isAll = bs == null;
        int i = i0 = isAll ? data.length - 1 : bs.nextSetBit(0);
        while (i >= 0) {
            float d = data[i];
            if (!Float.isNaN(d)) {
                this.ce.hi = Math.max(this.ce.hi, d);
                this.ce.lo = Math.min(this.ce.lo, d);
            }
            i = isAll ? i - 1 : bs.nextSetBit(i + 1);
        }
        this.setPropertyColorRange(this.ce.lo, this.ce.hi);
    }

    public void setPropertyColorRange(float min, float max) {
        this.ce.setRange(min, max, min > max);
        if (Logger.debugging) {
            Logger.debug("ColorManager: color \"" + this.ce.getCurrentColorSchemeName() + "\" range " + min + " " + max);
        }
    }

    void setPropertyColorScheme(String colorScheme, boolean isTranslucent, boolean isOverloaded) {
        boolean isReset;
        boolean bl = isReset = colorScheme.length() == 0;
        if (isReset) {
            colorScheme = "=";
        }
        float[] range = this.getPropertyColorRange();
        this.ce.currentPalette = this.ce.createColorScheme(colorScheme, true, isOverloaded);
        if (!isReset) {
            this.setPropertyColorRange(range[0], range[1]);
        }
        this.ce.isTranslucent = isTranslucent;
    }

    public String getColorSchemeList(String colorScheme) {
        int iPt = colorScheme == null || colorScheme.length() == 0 ? this.ce.currentPalette : this.ce.createColorScheme(colorScheme, true, false);
        return ColorEncoder.getColorSchemeList(this.ce.getColorSchemeArray(iPt));
    }

    public ColorEncoder getColorEncoder(String colorScheme) {
        if (colorScheme == null || colorScheme.length() == 0) {
            return this.ce;
        }
        ColorEncoder c = new ColorEncoder(this.ce, this.vwr);
        c.currentPalette = c.createColorScheme(colorScheme, false, true);
        return c.currentPalette == Integer.MAX_VALUE ? null : c;
    }
}

