/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl.constant;

import io.quarkus.gizmo2.impl.constant.ConstImpl;
import java.lang.constant.ConstantDesc;
import java.lang.constant.ConstantDescs;
import java.util.Optional;

public final class StringConst
extends ConstImpl {
    private final String value;
    private static final char[] hexDigits = "0123456789abcdef".toCharArray();

    public StringConst(String value) {
        super(ConstantDescs.CD_String);
        this.value = value;
    }

    public StringConst(ConstantDesc constantDesc) {
        this((String)((Object)constantDesc));
    }

    public String desc() {
        return this.value;
    }

    public Optional<String> describeConstable() {
        return Optional.of(this.desc());
    }

    @Override
    public boolean isNonZero() {
        return true;
    }

    @Override
    public boolean equals(ConstImpl obj) {
        StringConst other;
        return obj instanceof StringConst && this.equals(other = (StringConst)obj);
    }

    public boolean equals(StringConst other) {
        return this == other || other != null && this.value.equals(other.value);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public StringBuilder toShortString(StringBuilder b) {
        int cp;
        b.append('\"');
        block8: for (int i = 0; i < this.value.length(); i += Character.charCount(cp)) {
            cp = this.value.codePointAt(i);
            switch (cp) {
                case 8: {
                    b.append("\\b");
                    continue block8;
                }
                case 12: {
                    b.append("\\f");
                    continue block8;
                }
                case 10: {
                    b.append("\\n");
                    continue block8;
                }
                case 13: {
                    b.append("\\r");
                    continue block8;
                }
                case 9: {
                    b.append("\\t");
                    continue block8;
                }
                case 34: 
                case 92: {
                    b.append('\\').appendCodePoint(cp);
                    continue block8;
                }
                default: {
                    if (Character.isISOControl(cp)) {
                        assert (cp < 256);
                        b.append('\\').append('u').append("00").append(hexDigits[cp >>> 4]).append(hexDigits[cp & 0xF]);
                        continue block8;
                    }
                    b.appendCodePoint(cp);
                }
            }
        }
        b.append('\"');
        return b;
    }
}

